/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger.test;

import io.github.robwin.swagger.test.ConsumerDrivenValidator;
import io.github.robwin.swagger.test.DocumentationDrivenValidator;
import io.github.robwin.swagger.test.SchemaObjectResolver;
import io.github.robwin.swagger.test.SwaggerAssertionConfig;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.SwaggerParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.assertj.core.api.AbstractAssert;

public class SwaggerAssert
extends AbstractAssert<SwaggerAssert, Swagger> {
    private static final String ASSERTION_ENABLED_CONFIG_PATH = "/assertj-swagger.properties";
    private DocumentationDrivenValidator documentationDrivenValidator;
    private ConsumerDrivenValidator consumerDrivenValidator;

    public SwaggerAssert(Swagger actual) {
        super((Object)actual, SwaggerAssert.class);
        this.documentationDrivenValidator = new DocumentationDrivenValidator(actual, this.loadSwaggerAssertionFlagsConfiguration(ASSERTION_ENABLED_CONFIG_PATH));
        this.consumerDrivenValidator = new ConsumerDrivenValidator(actual, this.loadSwaggerAssertionFlagsConfiguration(ASSERTION_ENABLED_CONFIG_PATH));
    }

    public SwaggerAssert(Swagger actual, SwaggerAssertionConfig assertionConfig) {
        super((Object)actual, SwaggerAssert.class);
        this.documentationDrivenValidator = new DocumentationDrivenValidator(actual, assertionConfig);
        this.consumerDrivenValidator = new ConsumerDrivenValidator(actual, assertionConfig);
    }

    public SwaggerAssert(Swagger actual, String configurationResourceLocation) {
        super((Object)actual, SwaggerAssert.class);
        this.documentationDrivenValidator = new DocumentationDrivenValidator(actual, this.loadSwaggerAssertionFlagsConfiguration(configurationResourceLocation));
        this.consumerDrivenValidator = new ConsumerDrivenValidator(actual, this.loadSwaggerAssertionFlagsConfiguration(configurationResourceLocation));
    }

    public SwaggerAssert isEqualTo(Swagger expected) {
        SchemaObjectResolver schemaObjectResolver = new SchemaObjectResolver(expected, (Swagger)this.actual);
        this.documentationDrivenValidator.validateSwagger(expected, schemaObjectResolver);
        return (SwaggerAssert)this.myself;
    }

    public SwaggerAssert isEqualTo(String expectedLocation) {
        return this.isEqualTo(new SwaggerParser().read(expectedLocation));
    }

    public SwaggerAssert isEqualTo(String expectedLocation, List<AuthorizationValue> auths) {
        return this.isEqualTo(new SwaggerParser().read(expectedLocation, auths, true));
    }

    public SwaggerAssert satisfiesContract(Swagger expected) {
        SchemaObjectResolver schemaObjectResolver = new SchemaObjectResolver(expected, (Swagger)this.actual);
        this.consumerDrivenValidator.validateSwagger(expected, schemaObjectResolver);
        return (SwaggerAssert)this.myself;
    }

    public SwaggerAssert satisfiesContract(String expectedLocation) {
        return this.satisfiesContract(new SwaggerParser().read(expectedLocation));
    }

    public SwaggerAssert satisfiesContract(String expectedLocation, List<AuthorizationValue> auths) {
        return this.satisfiesContract(new SwaggerParser().read(expectedLocation, auths, true));
    }

    private SwaggerAssertionConfig loadSwaggerAssertionFlagsConfiguration(String configurationResourceLocation) {
        Properties props = new Properties();
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(configurationResourceLocation);){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SwaggerAssertionConfig(props);
    }
}

