/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka;

import io.opentracing.propagation.TextMap;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class HeadersMapExtractAdapter
implements TextMap {
    private final Map<String, String> map = new HashMap<String, String>();

    public HeadersMapExtractAdapter(Headers headers) {
        for (Header header : headers) {
            byte[] headerValue = header.value();
            this.map.put(header.key(), headerValue == null ? null : new String(headerValue, StandardCharsets.UTF_8));
        }
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    public void put(String key, String value) {
        throw new UnsupportedOperationException("HeadersMapExtractAdapter should only be used with Tracer.extract()");
    }
}

