/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.rabbitmq;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqSpanDecorator;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqTracingUtils;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.aop.AfterAdvice;
import org.springframework.aop.BeforeAdvice;

class RabbitMqReceiveTracingInterceptor
implements MethodInterceptor,
AfterAdvice,
BeforeAdvice {
    private final Tracer tracer;

    RabbitMqReceiveTracingInterceptor(Tracer tracer) {
        this.tracer = tracer;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Message message = (Message)methodInvocation.getArguments()[1];
        MessageProperties messageProperties = message.getMessageProperties();
        Optional<Scope> child = RabbitMqTracingUtils.buildReceiveSpan(messageProperties, this.tracer);
        RabbitMqSpanDecorator spanDecorator = new RabbitMqSpanDecorator();
        child.ifPresent(scope -> spanDecorator.onReceive(messageProperties, scope.span()));
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        catch (Exception ex) {
            child.ifPresent(scope -> spanDecorator.onError(ex, scope.span()));
            throw ex;
        }
        finally {
            child.ifPresent(Scope::close);
        }
    }
}

