/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.rabbitmq;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqInjectAdapter;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqSpanDecorator;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqTracingUtils;
import io.opentracing.propagation.Format;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConverter;

@Aspect
class RabbitMqSendTracingAspect {
    private final Tracer tracer;
    private final MessageConverter messageConverter;

    RabbitMqSendTracingAspect(Tracer tracer, MessageConverter messageConverter) {
        this.tracer = tracer;
        this.messageConverter = messageConverter;
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(..)) && args(exchange,routingKey, message)", argNames="pjp,exchange,routingKey,message")
    public Object traceRabbitSend(ProceedingJoinPoint pjp, String exchange, String routingKey, Object message) throws Throwable {
        Object[] args = pjp.getArgs();
        Message convertedMessage = this.convertMessageIfNecessary(message);
        MessageProperties messageProperties = convertedMessage.getMessageProperties();
        Scope scope = RabbitMqTracingUtils.buildSendSpan(this.tracer, messageProperties);
        this.tracer.inject(scope.span().context(), Format.Builtin.TEXT_MAP, (Object)new RabbitMqInjectAdapter(messageProperties));
        RabbitMqSpanDecorator spanDecorator = new RabbitMqSpanDecorator();
        spanDecorator.onSend(messageProperties, exchange, routingKey, scope.span());
        args[2] = convertedMessage;
        try {
            Object object = pjp.proceed(args);
            return object;
        }
        catch (Exception ex) {
            spanDecorator.onError(ex, scope.span());
            throw ex;
        }
        finally {
            scope.close();
        }
    }

    private Message convertMessageIfNecessary(Object object) {
        if (object instanceof Message) {
            return (Message)object;
        }
        return this.messageConverter.toMessage(object, new MessageProperties());
    }
}

