/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.$internal.com.google.common.util.concurrent.ListenableFuture;
import org.apache.cassandra.$internal.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.cassandra.$internal.com.google.common.util.concurrent.MoreExecutors;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.LengthAvailableInputStream;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSavingCache<K extends CacheKey, V>
extends InstrumentingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AutoSavingCache.class);
    public static final Set<CacheService.CacheType> flushInProgress = new NonBlockingHashSet();
    protected volatile ScheduledFuture<?> saveTask;
    protected final CacheService.CacheType cacheType;
    private CacheSerializer<K, V> cacheLoader;
    private static final String CURRENT_VERSION = "ba";
    private static volatile IStreamFactory streamFactory = new IStreamFactory(){

        @Override
        public InputStream getInputStream(File path) throws FileNotFoundException {
            return new FileInputStream(path);
        }

        @Override
        public OutputStream getOutputStream(File path) throws FileNotFoundException {
            return new FileOutputStream(path);
        }
    };

    public static void setStreamFactory(IStreamFactory streamFactory) {
        AutoSavingCache.streamFactory = streamFactory;
    }

    public AutoSavingCache(ICache<K, V> cache, CacheService.CacheType cacheType, CacheSerializer<K, V> cacheloader) {
        super(cacheType.toString(), cache);
        this.cacheType = cacheType;
        this.cacheLoader = cacheloader;
    }

    public File getCachePath(String version) {
        return DatabaseDescriptor.getSerializedCachePath(this.cacheType, version);
    }

    public Writer getWriter(int keysToSave) {
        return new Writer(keysToSave);
    }

    public void scheduleSaving(int savePeriodInSeconds, final int keysToSave) {
        if (this.saveTask != null) {
            this.saveTask.cancel(false);
            this.saveTask = null;
        }
        if (savePeriodInSeconds > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AutoSavingCache.this.submitWrite(keysToSave);
                }
            };
            this.saveTask = ScheduledExecutors.optionalTasks.scheduleWithFixedDelay(runnable, savePeriodInSeconds, savePeriodInSeconds, TimeUnit.SECONDS);
        }
    }

    public ListenableFuture<Integer> loadSavedAsync() {
        final ListeningExecutorService es = MoreExecutors.listeningDecorator(Executors.newSingleThreadExecutor());
        final long start = System.nanoTime();
        ListenableFuture<Integer> cacheLoad = es.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return AutoSavingCache.this.loadSaved();
            }
        });
        cacheLoad.addListener(new Runnable(){

            @Override
            public void run() {
                if (AutoSavingCache.this.size() > 0) {
                    logger.info("Completed loading ({} ms; {} keys) {} cache", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), CacheService.instance.keyCache.size(), AutoSavingCache.this.cacheType});
                }
                es.shutdown();
            }
        }, MoreExecutors.sameThreadExecutor());
        return cacheLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadSaved() {
        int count = 0;
        long start = System.nanoTime();
        File path = this.getCachePath(CURRENT_VERSION);
        if (path.exists()) {
            DataInputStream in = null;
            try {
                logger.info(String.format("reading saved cache %s", path));
                in = new DataInputStream(new LengthAvailableInputStream(new BufferedInputStream(streamFactory.getInputStream(path)), path.length()));
                UUID schemaVersion = new UUID(in.readLong(), in.readLong());
                if (!schemaVersion.equals(Schema.instance.getVersion())) {
                    throw new RuntimeException("Cache schema version " + schemaVersion.toString() + " does not match current schema version " + Schema.instance.getVersion());
                }
                ArrayDeque<Future<Pair<K, V>>> futures = new ArrayDeque<Future<Pair<K, V>>>();
                while (in.available() > 0) {
                    String cfname;
                    String ksname = in.readUTF();
                    ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreIncludingIndexes(Pair.create(ksname, cfname = in.readUTF()));
                    Future<Pair<K, V>> entryFuture = this.cacheLoader.deserialize(in, cfs);
                    if (entryFuture == null) continue;
                    futures.offer(entryFuture);
                    ++count;
                    while (true) {
                        if (futures.peek() != null && ((Future)futures.peek()).isDone()) {
                            Future future = (Future)futures.poll();
                            Pair entry = (Pair)future.get();
                            if (entry == null || entry.right == null) continue;
                            this.put(entry.left, entry.right);
                            continue;
                        }
                        if (futures.size() > 1000) {
                            Thread.yield();
                        }
                        if (futures.size() <= 1000) break;
                    }
                }
                Future future = null;
                while ((future = (Future)futures.poll()) != null) {
                    Pair entry = (Pair)future.get();
                    if (entry == null || entry.right == null) continue;
                    this.put(entry.left, entry.right);
                }
            }
            catch (Throwable t) {
                try {
                    JVMStabilityInspector.inspectThrowable(t);
                    logger.info(String.format("Harmless error reading saved cache %s", path.getAbsolutePath()), t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    FileUtils.closeQuietly(in);
                }
            }
            FileUtils.closeQuietly(in);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("completed reading ({} ms; {} keys) saved cache {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), count, path});
        }
        return count;
    }

    public Future<?> submitWrite(int keysToSave) {
        return CompactionManager.instance.submitCacheWrite(this.getWriter(keysToSave));
    }

    public static interface CacheSerializer<K extends CacheKey, V> {
        public void serialize(K var1, DataOutputPlus var2, ColumnFamilyStore var3) throws IOException;

        public Future<Pair<K, V>> deserialize(DataInputStream var1, ColumnFamilyStore var2) throws IOException;
    }

    public class Writer
    extends CompactionInfo.Holder {
        private final Set<K> keys;
        private final CompactionInfo info;
        private long keysWritten;

        protected Writer(int keysToSave) {
            this.keys = keysToSave >= AutoSavingCache.this.getKeySet().size() ? AutoSavingCache.this.getKeySet() : AutoSavingCache.this.hotKeySet(keysToSave);
            OperationType type = AutoSavingCache.this.cacheType == CacheService.CacheType.KEY_CACHE ? OperationType.KEY_CACHE_SAVE : (AutoSavingCache.this.cacheType == CacheService.CacheType.ROW_CACHE ? OperationType.ROW_CACHE_SAVE : (AutoSavingCache.this.cacheType == CacheService.CacheType.COUNTER_CACHE ? OperationType.COUNTER_CACHE_SAVE : OperationType.UNKNOWN));
            this.info = new CompactionInfo(CFMetaData.denseCFMetaData("system", AutoSavingCache.this.cacheType.toString(), BytesType.instance), type, 0L, this.keys.size(), "keys");
        }

        public CacheService.CacheType cacheType() {
            return AutoSavingCache.this.cacheType;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            return this.info.forProgress(this.keysWritten, Math.max(this.keysWritten, (long)this.keys.size()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void saveCache() {
            File tempCacheFile;
            long start;
            block11: {
                logger.debug("Deleting old {} files.", (Object)AutoSavingCache.this.cacheType);
                this.deleteOldCacheFiles();
                if (this.keys.isEmpty()) {
                    logger.debug("Skipping {} save, cache is empty.", (Object)AutoSavingCache.this.cacheType);
                    return;
                }
                start = System.nanoTime();
                DataOutputStreamPlus writer = null;
                tempCacheFile = this.tempCacheFile();
                try {
                    try {
                        writer = new DataOutputStreamPlus(streamFactory.getOutputStream(tempCacheFile));
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        UUID schemaVersion = Schema.instance.getVersion();
                        if (schemaVersion == null) {
                            Schema.instance.updateVersion();
                            schemaVersion = Schema.instance.getVersion();
                        }
                        writer.writeLong(schemaVersion.getMostSignificantBits());
                        writer.writeLong(schemaVersion.getLeastSignificantBits());
                        for (CacheKey key : this.keys) {
                            ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreIncludingIndexes(key.ksAndCFName);
                            if (cfs == null) continue;
                            AutoSavingCache.this.cacheLoader.serialize(key, writer, cfs);
                            ++this.keysWritten;
                        }
                    }
                    catch (IOException e) {
                        throw new FSWriteError((Throwable)e, tempCacheFile);
                    }
                    if (writer == null) break block11;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        FileUtils.closeQuietly(writer);
                    }
                    throw throwable;
                }
                FileUtils.closeQuietly(writer);
            }
            File cacheFile = AutoSavingCache.this.getCachePath(AutoSavingCache.CURRENT_VERSION);
            cacheFile.delete();
            if (!tempCacheFile.renameTo(cacheFile)) {
                logger.error("Unable to rename {} to {}", (Object)tempCacheFile, (Object)cacheFile);
            }
            logger.info("Saved {} ({} items) in {} ms", new Object[]{AutoSavingCache.this.cacheType, this.keys.size(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)});
        }

        private File tempCacheFile() {
            File path = AutoSavingCache.this.getCachePath(AutoSavingCache.CURRENT_VERSION);
            return FileUtils.createTempFile(path.getName(), null, path.getParentFile());
        }

        private void deleteOldCacheFiles() {
            File savedCachesDir = new File(DatabaseDescriptor.getSavedCachesLocation());
            assert (savedCachesDir.exists() && savedCachesDir.isDirectory());
            File[] files = savedCachesDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(AutoSavingCache.this.cacheType.toString()) && !file.getName().endsWith(String.format("%s-%s.db", AutoSavingCache.this.cacheType.toString(), AutoSavingCache.CURRENT_VERSION)) || file.delete()) continue;
                    logger.warn("Failed to delete {}", (Object)file.getAbsolutePath());
                }
            } else {
                logger.warn("Could not list files in {}", (Object)savedCachesDir);
            }
        }
    }

    public static interface IStreamFactory {
        public InputStream getInputStream(File var1) throws FileNotFoundException;

        public OutputStream getOutputStream(File var1) throws FileNotFoundException;
    }
}

