/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.$internal.com.google.common.base.Predicates;
import org.apache.cassandra.$internal.com.google.common.collect.Iterators;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.StreamingHistogram;

public class LazilyCompactedRow
extends AbstractCompactedRow {
    private final List<? extends OnDiskAtomIterator> rows;
    private final CompactionController controller;
    private boolean hasCalculatedMaxPurgeableTimestamp = false;
    private long maxPurgeableTimestamp;
    private final ColumnFamily emptyColumnFamily;
    private ColumnStats columnStats;
    private boolean closed;
    private ColumnIndex.Builder indexBuilder;
    private final SecondaryIndexManager.Updater indexer;
    private final Reducer reducer;
    private final Iterator<OnDiskAtom> merger;
    private DeletionTime maxRowTombstone;

    public LazilyCompactedRow(CompactionController controller, List<? extends OnDiskAtomIterator> rows) {
        super(rows.get(0).getKey());
        this.rows = rows;
        this.controller = controller;
        this.indexer = controller.cfs.indexManager.gcUpdaterFor(this.key);
        this.maxRowTombstone = DeletionTime.LIVE;
        for (OnDiskAtomIterator onDiskAtomIterator : rows) {
            DeletionTime rowTombstone = onDiskAtomIterator.getColumnFamily().deletionInfo().getTopLevelDeletion();
            if (this.maxRowTombstone.compareTo(rowTombstone) >= 0) continue;
            this.maxRowTombstone = rowTombstone;
        }
        this.emptyColumnFamily = ArrayBackedSortedColumns.factory.create(controller.cfs.metadata);
        this.emptyColumnFamily.delete(this.maxRowTombstone);
        if (!this.maxRowTombstone.isLive() && this.maxRowTombstone.markedForDeleteAt < this.getMaxPurgeableTimestamp()) {
            this.emptyColumnFamily.purgeTombstones(controller.gcBefore);
        }
        this.reducer = new Reducer();
        this.merger = Iterators.filter(MergeIterator.get(rows, this.emptyColumnFamily.getComparator().onDiskAtomComparator(), this.reducer), Predicates.notNull());
    }

    private long getMaxPurgeableTimestamp() {
        if (!this.hasCalculatedMaxPurgeableTimestamp) {
            this.hasCalculatedMaxPurgeableTimestamp = true;
            this.maxPurgeableTimestamp = this.controller.maxPurgeableTimestamp(this.key);
        }
        return this.maxPurgeableTimestamp;
    }

    private static void removeDeleted(ColumnFamily cf, boolean shouldPurge, DecoratedKey key, CompactionController controller) {
        int overriddenGCBefore = shouldPurge ? controller.gcBefore : Integer.MIN_VALUE;
        ColumnFamilyStore.removeDeletedColumnsOnly(cf, overriddenGCBefore, controller.cfs.indexManager.gcUpdaterFor(key));
    }

    @Override
    public RowIndexEntry write(long currentPosition, DataOutputPlus out) throws IOException {
        ColumnIndex columnsIndex;
        assert (!this.closed);
        try {
            this.indexBuilder = new ColumnIndex.Builder(this.emptyColumnFamily, this.key.getKey(), out);
            columnsIndex = this.indexBuilder.buildForCompaction(this.merger);
            if (columnsIndex.columnsIndex.isEmpty() && !this.emptyColumnFamily.isMarkedForDelete()) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.columnStats = new ColumnStats(this.reducer.columns, this.reducer.minTimestampTracker.get(), Math.max(this.emptyColumnFamily.deletionInfo().maxTimestamp(), this.reducer.maxTimestampTracker.get()), this.reducer.maxDeletionTimeTracker.get(), this.reducer.tombstones, this.reducer.minColumnNameSeen, this.reducer.maxColumnNameSeen, this.reducer.hasLegacyCounterShards);
        this.indexBuilder.maybeWriteEmptyRowHeader();
        out.writeShort(0);
        this.close();
        return RowIndexEntry.create(currentPosition, this.emptyColumnFamily.deletionInfo().getTopLevelDeletion(), columnsIndex);
    }

    @Override
    public void update(final MessageDigest digest) {
        assert (!this.closed);
        DataOutputBuffer out = new DataOutputBuffer();
        OnDiskAtom.SerializerForWriting serializer = new OnDiskAtom.SerializerForWriting(){

            @Override
            public void serializeForSSTable(OnDiskAtom atom, DataOutputPlus out) throws IOException {
                atom.updateDigest(digest);
            }

            @Override
            public long serializedSizeForSSTable(OnDiskAtom atom) {
                return 0L;
            }
        };
        this.indexBuilder = new ColumnIndex.Builder(this.emptyColumnFamily, this.key.getKey(), out, serializer);
        try {
            DeletionTime.serializer.serialize(this.emptyColumnFamily.deletionInfo().getTopLevelDeletion(), (DataOutputPlus)out);
            if (this.merger.hasNext() || this.emptyColumnFamily.deletionInfo().getTopLevelDeletion() != DeletionTime.LIVE) {
                digest.update(out.getData(), 0, out.getLength());
            }
            this.indexBuilder.buildForCompaction(this.merger);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.close();
    }

    @Override
    public ColumnStats columnStats() {
        return this.columnStats;
    }

    @Override
    public void close() {
        for (OnDiskAtomIterator onDiskAtomIterator : this.rows) {
            try {
                onDiskAtomIterator.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.closed = true;
    }

    private class Reducer
    extends MergeIterator.Reducer<OnDiskAtom, OnDiskAtom> {
        ColumnFamily container;
        RangeTombstone tombstone;
        int columns;
        ColumnStats.MinLongTracker minTimestampTracker;
        ColumnStats.MaxLongTracker maxTimestampTracker;
        ColumnStats.MaxIntTracker maxDeletionTimeTracker;
        StreamingHistogram tombstones;
        List<ByteBuffer> minColumnNameSeen;
        List<ByteBuffer> maxColumnNameSeen;
        boolean hasLegacyCounterShards;

        public Reducer() {
            this.container = ArrayBackedSortedColumns.factory.create(LazilyCompactedRow.this.emptyColumnFamily.metadata());
            this.columns = 0;
            this.minTimestampTracker = new ColumnStats.MinLongTracker(Long.MIN_VALUE);
            this.maxTimestampTracker = new ColumnStats.MaxLongTracker(Long.MAX_VALUE);
            this.maxDeletionTimeTracker = new ColumnStats.MaxIntTracker(Integer.MAX_VALUE);
            this.tombstones = new StreamingHistogram(100);
            this.minColumnNameSeen = Collections.emptyList();
            this.maxColumnNameSeen = Collections.emptyList();
            this.hasLegacyCounterShards = false;
            this.minTimestampTracker.update(LazilyCompactedRow.this.maxRowTombstone.isLive() ? Long.MAX_VALUE : ((LazilyCompactedRow)LazilyCompactedRow.this).maxRowTombstone.markedForDeleteAt);
            this.maxTimestampTracker.update(((LazilyCompactedRow)LazilyCompactedRow.this).maxRowTombstone.markedForDeleteAt);
            this.maxDeletionTimeTracker.update(LazilyCompactedRow.this.maxRowTombstone.isLive() ? Integer.MIN_VALUE : ((LazilyCompactedRow)LazilyCompactedRow.this).maxRowTombstone.localDeletionTime);
            if (!LazilyCompactedRow.this.maxRowTombstone.isLive()) {
                this.tombstones.update(((LazilyCompactedRow)LazilyCompactedRow.this).maxRowTombstone.localDeletionTime);
            }
        }

        @Override
        public void reduce(OnDiskAtom current) {
            if (current instanceof RangeTombstone) {
                if (this.tombstone == null || current.timestamp() >= this.tombstone.timestamp()) {
                    this.tombstone = (RangeTombstone)current;
                }
            } else {
                Cell cell = (Cell)current;
                this.container.addColumn(cell);
                if (LazilyCompactedRow.this.indexer == SecondaryIndexManager.nullUpdater) {
                    return;
                }
                if (cell.isLive() && !this.container.getColumn(cell.name()).equals(cell)) {
                    LazilyCompactedRow.this.indexer.remove(cell);
                }
            }
        }

        @Override
        protected OnDiskAtom getReduced() {
            if (this.tombstone != null) {
                RangeTombstone t = this.tombstone;
                this.tombstone = null;
                if (((DeletionTime)t.data).isGcAble(((LazilyCompactedRow)LazilyCompactedRow.this).controller.gcBefore) && t.timestamp() < LazilyCompactedRow.this.getMaxPurgeableTimestamp()) {
                    LazilyCompactedRow.this.indexBuilder.tombstoneTracker().update(t, true);
                    return null;
                }
                this.tombstones.update(t.getLocalDeletionTime());
                this.minTimestampTracker.update(t.timestamp());
                this.maxTimestampTracker.update(t.timestamp());
                this.maxDeletionTimeTracker.update(t.getLocalDeletionTime());
                this.minColumnNameSeen = ColumnNameHelper.minComponents(this.minColumnNameSeen, (Composite)t.min, ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
                this.maxColumnNameSeen = ColumnNameHelper.maxComponents(this.maxColumnNameSeen, (Composite)t.max, ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
                return t;
            }
            this.container.delete(LazilyCompactedRow.this.maxRowTombstone);
            Iterator<Cell> iter = this.container.iterator();
            Cell c = iter.next();
            boolean shouldPurge = c.getLocalDeletionTime() < Integer.MAX_VALUE && c.timestamp() < LazilyCompactedRow.this.getMaxPurgeableTimestamp();
            LazilyCompactedRow.removeDeleted(this.container, shouldPurge, LazilyCompactedRow.this.key, LazilyCompactedRow.this.controller);
            iter = this.container.iterator();
            if (!iter.hasNext()) {
                this.container = ArrayBackedSortedColumns.factory.create(LazilyCompactedRow.this.emptyColumnFamily.metadata());
                return null;
            }
            int localDeletionTime = this.container.deletionInfo().getTopLevelDeletion().localDeletionTime;
            if (localDeletionTime < Integer.MAX_VALUE) {
                this.tombstones.update(localDeletionTime);
            }
            Cell reduced = iter.next();
            this.container = ArrayBackedSortedColumns.factory.create(LazilyCompactedRow.this.emptyColumnFamily.metadata());
            if (LazilyCompactedRow.this.indexBuilder.tombstoneTracker().isDeleted(reduced)) {
                LazilyCompactedRow.this.indexBuilder.tombstoneTracker().update(reduced, false);
                LazilyCompactedRow.this.indexer.remove(reduced);
                return null;
            }
            ++this.columns;
            this.minTimestampTracker.update(reduced.timestamp());
            this.maxTimestampTracker.update(reduced.timestamp());
            this.maxDeletionTimeTracker.update(reduced.getLocalDeletionTime());
            this.minColumnNameSeen = ColumnNameHelper.minComponents(this.minColumnNameSeen, reduced.name(), ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
            this.maxColumnNameSeen = ColumnNameHelper.maxComponents(this.maxColumnNameSeen, reduced.name(), ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
            int deletionTime = reduced.getLocalDeletionTime();
            if (deletionTime < Integer.MAX_VALUE) {
                this.tombstones.update(deletionTime);
            }
            if (reduced instanceof CounterCell) {
                this.hasLegacyCounterShards = this.hasLegacyCounterShards || ((CounterCell)reduced).hasLegacyShards();
            }
            return reduced;
        }
    }
}

