/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.keys;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.keys.KeysIndex;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(KeysSearcher.class);

    public KeysSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        super(indexManager, columns);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Row> search(ExtendedFilter filter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ColumnFamilyStore.AbstractScanIterator getIndexedIterator(final OpOrder.Group writeOp, final ExtendedFilter filter, final IndexExpression primary, final SecondaryIndex index) {
        assert (index != null);
        assert (index.getIndexCfs() != null);
        final DecoratedKey indexKey = index.getIndexKeyFor(primary.value);
        if (logger.isDebugEnabled()) {
            logger.debug("Most-selective indexed predicate is {}", (Object)((AbstractSimplePerColumnSecondaryIndex)index).expressionString(primary));
        }
        final AbstractBounds<RowPosition> range = filter.dataRange.keyRange();
        CellNameType type = index.getIndexCfs().getComparator();
        final Composite startKey = range.left instanceof DecoratedKey ? type.make(((DecoratedKey)range.left).getKey()) : Composites.EMPTY;
        final Composite endKey = range.right instanceof DecoratedKey ? type.make(((DecoratedKey)range.right).getKey()) : Composites.EMPTY;
        final CellName primaryColumn = this.baseCfs.getComparator().cellFromByteBuffer(primary.column);
        return new ColumnFamilyStore.AbstractScanIterator(){
            private Composite lastSeenKey;
            private Iterator<Cell> indexColumns;
            private int columnsRead;
            {
                this.lastSeenKey = startKey;
                this.columnsRead = Integer.MAX_VALUE;
            }

            @Override
            protected Row computeNext() {
                ColumnFamily data;
                DecoratedKey dk;
                int rowsPerQuery = Math.max(Math.min(filter.maxRows(), filter.maxColumns()), 2);
                block0: while (true) {
                    if (this.indexColumns == null || !this.indexColumns.hasNext()) {
                        if (this.columnsRead < rowsPerQuery) {
                            logger.trace("Read only {} (< {}) last page through, must be done", (Object)this.columnsRead, (Object)rowsPerQuery);
                            return (Row)this.endOfData();
                        }
                        if (logger.isTraceEnabled() && index instanceof AbstractSimplePerColumnSecondaryIndex) {
                            logger.trace("Scanning index {} starting with {}", (Object)((AbstractSimplePerColumnSecondaryIndex)index).expressionString(primary), (Object)index.getBaseCfs().metadata.getKeyValidator().getString(startKey.toByteBuffer()));
                        }
                        QueryFilter indexFilter = QueryFilter.getSliceFilter(indexKey, index.getIndexCfs().name, this.lastSeenKey, endKey, false, rowsPerQuery, filter.timestamp);
                        ColumnFamily indexRow = index.getIndexCfs().getColumnFamily(indexFilter);
                        logger.trace("fetched {}", (Object)indexRow);
                        if (indexRow == null) {
                            logger.trace("no data, all done");
                            return (Row)this.endOfData();
                        }
                        Collection<Cell> sortedCells = indexRow.getSortedColumns();
                        this.columnsRead = sortedCells.size();
                        this.indexColumns = sortedCells.iterator();
                        Cell firstCell = sortedCells.iterator().next();
                        if (this.lastSeenKey != startKey && this.lastSeenKey.equals(firstCell.name())) {
                            this.indexColumns.next();
                            logger.trace("Skipping {}", (Object)((KeysSearcher)KeysSearcher.this).baseCfs.metadata.getKeyValidator().getString(firstCell.name().toByteBuffer()));
                        } else if (range instanceof Range && this.indexColumns.hasNext() && firstCell.name().equals(startKey)) {
                            this.indexColumns.next();
                            logger.trace("Skipping first key as range excludes it");
                        }
                    }
                    while (true) {
                        ColumnFamily cf;
                        IDiskAtomFilter extraFilter;
                        if (!this.indexColumns.hasNext()) continue block0;
                        Cell cell = this.indexColumns.next();
                        this.lastSeenKey = cell.name();
                        if (!cell.isLive(filter.timestamp)) {
                            logger.trace("skipping {}", (Object)cell.name());
                            continue;
                        }
                        dk = ((KeysSearcher)KeysSearcher.this).baseCfs.partitioner.decorateKey(this.lastSeenKey.toByteBuffer());
                        if (!((RowPosition)range.right).isMinimum(((KeysSearcher)KeysSearcher.this).baseCfs.partitioner) && ((RowPosition)range.right).compareTo(dk) < 0) {
                            logger.trace("Reached end of assigned scan range");
                            return (Row)this.endOfData();
                        }
                        if (!range.contains(dk)) {
                            logger.trace("Skipping entry {} outside of assigned scan range", (Object)dk.getToken());
                            continue;
                        }
                        logger.trace("Returning index hit for {}", (Object)dk);
                        data = KeysSearcher.this.baseCfs.getColumnFamily(new QueryFilter(dk, ((KeysSearcher)KeysSearcher.this).baseCfs.name, filter.columnFilter(this.lastSeenKey.toByteBuffer()), filter.timestamp));
                        if (data == null) {
                            data = ArrayBackedSortedColumns.factory.create(((KeysSearcher)KeysSearcher.this).baseCfs.metadata);
                        }
                        if ((extraFilter = filter.getExtraFilter(dk, data)) != null && (cf = KeysSearcher.this.baseCfs.getColumnFamily(new QueryFilter(dk, ((KeysSearcher)KeysSearcher.this).baseCfs.name, extraFilter, filter.timestamp))) != null) {
                            data.addAll(cf);
                        }
                        if (!((KeysIndex)index).isIndexEntryStale(indexKey.getKey(), data, filter.timestamp)) break block0;
                        BufferCell dummyCell = new BufferCell(primaryColumn, indexKey.getKey(), cell.timestamp());
                        ((PerColumnSecondaryIndex)index).delete(dk.getKey(), dummyCell, writeOp);
                    }
                    break;
                }
                return new Row(dk, data);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

