/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.$internal.com.google.common.collect.AbstractIterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.serializers.MarshalException;

public class SSTableIdentityIterator
implements Comparable<SSTableIdentityIterator>,
OnDiskAtomIterator {
    private final DecoratedKey key;
    private final DataInput in;
    public final long dataSize;
    public final ColumnSerializer.Flag flag;
    private final ColumnFamily columnFamily;
    private final Iterator<OnDiskAtom> atomIterator;
    private final boolean validateColumns;
    private final String filename;
    private final SSTableReader sstable;

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey key, long dataSize) {
        this(sstable, file, key, dataSize, false);
    }

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey key, long dataSize, boolean checkData) {
        this(sstable.metadata, file, file.getPath(), key, dataSize, checkData, sstable, ColumnSerializer.Flag.LOCAL);
    }

    public static SSTableIdentityIterator createFragmentIterator(SSTableReader sstable, final RandomAccessReader file, DecoratedKey key, long dataSize, boolean checkData) {
        final ColumnSerializer.Flag flag = ColumnSerializer.Flag.LOCAL;
        final CellNameType type = sstable.metadata.comparator;
        final int expireBefore = (int)(System.currentTimeMillis() / 1000L);
        final Descriptor.Version version = sstable.descriptor.version;
        final long dataEnd = file.getFilePointer() + dataSize;
        return new SSTableIdentityIterator(sstable.metadata, file, file.getPath(), key, dataSize, checkData, sstable, flag, DeletionTime.LIVE, (Iterator<OnDiskAtom>)new AbstractIterator<OnDiskAtom>(){

            @Override
            protected OnDiskAtom computeNext() {
                if (file.getFilePointer() >= dataEnd) {
                    return (OnDiskAtom)this.endOfData();
                }
                try {
                    return type.onDiskAtomSerializer().deserializeFromSSTable(file, flag, expireBefore, version);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        });
    }

    private SSTableIdentityIterator(CFMetaData metadata, DataInput in, String filename, DecoratedKey key, long dataSize, boolean checkData, SSTableReader sstable, ColumnSerializer.Flag flag) {
        this(metadata, in, filename, key, dataSize, checkData, sstable, flag, SSTableIdentityIterator.readDeletionTime(in, sstable, filename), metadata.getOnDiskIterator(in, flag, (int)(System.currentTimeMillis() / 1000L), sstable == null ? Descriptor.Version.CURRENT : sstable.descriptor.version));
    }

    private static DeletionTime readDeletionTime(DataInput in, SSTableReader sstable, String filename) {
        try {
            return DeletionTime.serializer.deserialize(in);
        }
        catch (IOException e) {
            if (sstable != null) {
                sstable.markSuspect();
            }
            throw new CorruptSSTableException((Exception)e, filename);
        }
    }

    private SSTableIdentityIterator(CFMetaData metadata, DataInput in, String filename, DecoratedKey key, long dataSize, boolean checkData, SSTableReader sstable, ColumnSerializer.Flag flag, DeletionTime deletion, Iterator<OnDiskAtom> atomIterator) {
        assert (!checkData || sstable != null);
        this.in = in;
        this.filename = filename;
        this.key = key;
        this.dataSize = dataSize;
        this.flag = flag;
        this.validateColumns = checkData;
        this.sstable = sstable;
        this.columnFamily = ArrayBackedSortedColumns.factory.create(metadata);
        this.columnFamily.delete(deletion);
        this.atomIterator = atomIterator;
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.columnFamily;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.atomIterator.hasNext();
        }
        catch (IOError e) {
            if (e.getCause() instanceof IOException) {
                if (this.sstable != null) {
                    this.sstable.markSuspect();
                }
                throw new CorruptSSTableException((Exception)((IOException)e.getCause()), this.filename);
            }
            throw e;
        }
    }

    @Override
    public OnDiskAtom next() {
        try {
            OnDiskAtom atom = this.atomIterator.next();
            if (this.validateColumns) {
                atom.validateFields(this.columnFamily.metadata());
            }
            return atom;
        }
        catch (MarshalException me) {
            throw new CorruptSSTableException((Exception)me, this.filename);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    public String getPath() {
        if (this.in instanceof RandomAccessReader) {
            RandomAccessReader file = (RandomAccessReader)this.in;
            return file.getPath();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(SSTableIdentityIterator o) {
        return this.key.compareTo(o.key);
    }
}

