/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.$internal.com.google.common.base.Objects;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.StreamingRepairTask;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.messages.SyncComplete;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Differencer
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(Differencer.class);
    private final RepairJobDesc desc;
    public final TreeResponse r1;
    public final TreeResponse r2;
    public final List<Range<Token>> differences = new ArrayList<Range<Token>>();

    public Differencer(RepairJobDesc desc, TreeResponse r1, TreeResponse r2) {
        this.desc = desc;
        this.r1 = r1;
        this.r2 = r2;
    }

    @Override
    public void run() {
        this.differences.addAll(MerkleTree.difference(this.r1.tree, this.r2.tree));
        String format = String.format("[repair #%s] Endpoints %s and %s %%s for %s", this.desc.sessionId, this.r1.endpoint, this.r2.endpoint, this.desc.columnFamily);
        if (this.differences.isEmpty()) {
            logger.info(String.format(format, "are consistent"));
            MessagingService.instance().sendOneWay(new SyncComplete(this.desc, this.r1.endpoint, this.r2.endpoint, true).createMessage(), FBUtilities.getLocalAddress());
            return;
        }
        logger.info(String.format(format, "have " + this.differences.size() + " range(s) out of sync"));
        this.performStreamingRepair();
    }

    void performStreamingRepair() {
        InetAddress local = FBUtilities.getBroadcastAddress();
        InetAddress src = this.r2.endpoint.equals(local) ? this.r2.endpoint : this.r1.endpoint;
        InetAddress dst = this.r2.endpoint.equals(local) ? this.r1.endpoint : this.r2.endpoint;
        SyncRequest request = new SyncRequest(this.desc, local, src, dst, this.differences);
        StreamingRepairTask task = new StreamingRepairTask(this.desc, request);
        task.run();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Differencer that = (Differencer)o;
        if (!this.desc.equals(that.desc)) {
            return false;
        }
        return this.minEndpoint().equals(that.minEndpoint()) && this.maxEndpoint().equals(that.maxEndpoint());
    }

    public int hashCode() {
        return Objects.hashCode(this.desc, this.minEndpoint(), this.maxEndpoint());
    }

    private InetAddress minEndpoint() {
        return FBUtilities.compareUnsigned(this.r1.endpoint.getAddress(), this.r2.endpoint.getAddress()) < 0 ? this.r1.endpoint : this.r2.endpoint;
    }

    private InetAddress maxEndpoint() {
        return FBUtilities.compareUnsigned(this.r1.endpoint.getAddress(), this.r2.endpoint.getAddress()) < 0 ? this.r2.endpoint : this.r1.endpoint;
    }

    public String toString() {
        return "#<Differencer " + this.r1.endpoint + "<->" + this.r2.endpoint + ":" + this.desc.columnFamily + "@" + this.desc.range + ">";
    }
}

