/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.$internal.com.google.common.base.Predicate;
import org.apache.cassandra.$internal.com.google.common.util.concurrent.ListenableFuture;
import org.apache.cassandra.$internal.com.google.common.util.concurrent.MoreExecutors;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.StreamingRepairTask;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.repair.messages.AnticompactionRequest;
import org.apache.cassandra.repair.messages.CleanupMessage;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairMessageVerbHandler
implements IVerbHandler<RepairMessage> {
    private static final Logger logger = LoggerFactory.getLogger(RepairMessageVerbHandler.class);

    @Override
    public void doVerb(final MessageIn<RepairMessage> message, final int id) {
        RepairJobDesc desc = ((RepairMessage)message.payload).desc;
        try {
            switch (((RepairMessage)message.payload).messageType) {
                case PREPARE_MESSAGE: {
                    PrepareMessage prepareMessage = (PrepareMessage)message.payload;
                    ArrayList<ColumnFamilyStore> columnFamilyStores = new ArrayList<ColumnFamilyStore>(prepareMessage.cfIds.size());
                    for (UUID cfId : prepareMessage.cfIds) {
                        Pair<String, String> kscf = Schema.instance.getCF(cfId);
                        ColumnFamilyStore columnFamilyStore = Keyspace.open((String)kscf.left).getColumnFamilyStore((String)kscf.right);
                        columnFamilyStores.add(columnFamilyStore);
                    }
                    ActiveRepairService.instance.registerParentRepairSession(prepareMessage.parentRepairSession, message.from, columnFamilyStores, prepareMessage.ranges);
                    MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE), id, message.from);
                    break;
                }
                case SNAPSHOT: {
                    ColumnFamilyStore cfs = Keyspace.open(desc.keyspace).getColumnFamilyStore(desc.columnFamily);
                    final Range<Token> repairingRange = desc.range;
                    cfs.snapshot(desc.sessionId.toString(), new Predicate<SSTableReader>(){

                        @Override
                        public boolean apply(SSTableReader sstable) {
                            return sstable != null && !(sstable.partitioner instanceof LocalPartitioner) && ((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(Collections.singleton(repairingRange));
                        }
                    }, true);
                    logger.debug("Enqueuing response to snapshot request {} to {}", (Object)desc.sessionId, (Object)message.from);
                    MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE), id, message.from);
                    break;
                }
                case VALIDATION_REQUEST: {
                    ValidationRequest validationRequest = (ValidationRequest)message.payload;
                    ColumnFamilyStore store = Keyspace.open(desc.keyspace).getColumnFamilyStore(desc.columnFamily);
                    Validator validator = new Validator(desc, message.from, validationRequest.gcBefore);
                    CompactionManager.instance.submitValidation(store, validator);
                    break;
                }
                case SYNC_REQUEST: {
                    SyncRequest request = (SyncRequest)message.payload;
                    StreamingRepairTask task = new StreamingRepairTask(desc, request);
                    task.run();
                    break;
                }
                case ANTICOMPACTION_REQUEST: {
                    logger.debug("Got anticompaction request");
                    AnticompactionRequest anticompactionRequest = (AnticompactionRequest)message.payload;
                    ListenableFuture<List<Object>> compactionDone = ActiveRepairService.instance.doAntiCompaction(anticompactionRequest.parentRepairSession);
                    compactionDone.addListener(new Runnable(){

                        @Override
                        public void run() {
                            MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE), id, message.from);
                        }
                    }, MoreExecutors.sameThreadExecutor());
                    break;
                }
                case CLEANUP: {
                    logger.debug("cleaning up repair");
                    CleanupMessage cleanup = (CleanupMessage)message.payload;
                    ActiveRepairService.instance.removeParentRepairSession(cleanup.parentRepairSession);
                    MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE), id, message.from);
                    break;
                }
                default: {
                    ActiveRepairService.instance.handleMessage(message.from, (RepairMessage)message.payload);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Got error, removing parent repair session");
            if (desc != null && desc.parentSessionId != null) {
                ActiveRepairService.instance.removeParentRepairSession(desc.parentSessionId);
            }
            throw new RuntimeException(e);
        }
    }
}

