/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.$internal.com.google.common.collect.ImmutableMap;
import org.apache.cassandra.$internal.com.google.common.collect.Multimap;
import org.apache.cassandra.$internal.com.google.common.collect.Sets;
import org.apache.cassandra.$internal.com.google.common.util.concurrent.Futures;
import org.apache.cassandra.$internal.com.google.common.util.concurrent.ListenableFuture;
import org.apache.cassandra.$internal.com.google.common.util.concurrent.MoreExecutors;
import org.apache.cassandra.concurrent.JMXConfigurableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.AnticompactionTask;
import org.apache.cassandra.repair.RepairFuture;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairParallelism;
import org.apache.cassandra.repair.RepairSession;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.SyncComplete;
import org.apache.cassandra.repair.messages.ValidationComplete;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveRepairService
implements IEndpointStateChangeSubscriber,
IFailureDetectionEventListener {
    private static final Logger logger = LoggerFactory.getLogger(ActiveRepairService.class);
    public static final ActiveRepairService instance = new ActiveRepairService();
    public static final long UNREPAIRED_SSTABLE = 0L;
    private static final ThreadPoolExecutor executor = new JMXConfigurableThreadPoolExecutor(4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("AntiEntropySessions"), "internal");
    private boolean registeredForEndpointChanges = false;
    private final ConcurrentMap<UUID, RepairSession> sessions = new ConcurrentHashMap<UUID, RepairSession>();
    private final ConcurrentMap<UUID, ParentRepairSession> parentRepairSessions = new ConcurrentHashMap<UUID, ParentRepairSession>();

    protected ActiveRepairService() {
    }

    public RepairFuture submitRepairSession(UUID parentRepairSession, Range<Token> range, String keyspace, RepairParallelism parallelismDegree, Set<InetAddress> endpoints, String ... cfnames) {
        if (cfnames.length == 0) {
            return null;
        }
        RepairSession session = new RepairSession(parentRepairSession, range, keyspace, parallelismDegree, endpoints, cfnames);
        if (session.endpoints.isEmpty()) {
            return null;
        }
        RepairFuture futureTask = new RepairFuture(session);
        executor.execute(futureTask);
        return futureTask;
    }

    public void addToActiveSessions(RepairSession session) {
        this.sessions.put(session.getId(), session);
        Gossiper.instance.register(session);
        FailureDetector.instance.registerFailureDetectionEventListener(session);
    }

    public void removeFromActiveSessions(RepairSession session) {
        Gossiper.instance.unregister(session);
        this.sessions.remove(session.getId());
    }

    public synchronized void terminateSessions() {
        for (RepairSession session : this.sessions.values()) {
            session.forceShutdown();
        }
        this.parentRepairSessions.clear();
    }

    RepairFuture submitArtificialRepairSession(RepairJobDesc desc) {
        HashSet<InetAddress> neighbours = new HashSet<InetAddress>();
        Collection<Range<Token>> keyspaceLocalRanges = StorageService.instance.getLocalRanges(desc.keyspace);
        neighbours.addAll(ActiveRepairService.getNeighbors(desc.keyspace, keyspaceLocalRanges, desc.range, null, null));
        RepairSession session = new RepairSession(desc.parentSessionId, desc.sessionId, desc.range, desc.keyspace, RepairParallelism.PARALLEL, neighbours, new String[]{desc.columnFamily});
        this.sessions.put(session.getId(), session);
        RepairFuture futureTask = new RepairFuture(session);
        executor.execute(futureTask);
        return futureTask;
    }

    public static Set<InetAddress> getNeighbors(String keyspaceName, Collection<Range<Token>> keyspaceLocalRanges, Range<Token> toRepair, Collection<String> dataCenters, Collection<String> hosts) {
        StorageService ss = StorageService.instance;
        Map<Range<Token>, List<InetAddress>> replicaSets = ss.getRangeToAddressMap(keyspaceName);
        Range<Token> rangeSuperSet = null;
        for (Range<Token> range : keyspaceLocalRanges) {
            if (range.contains((Token)((Object)toRepair))) {
                rangeSuperSet = range;
                break;
            }
            if (!range.intersects(toRepair)) continue;
            throw new IllegalArgumentException("Requested range intersects a local range but is not fully contained in one; this would lead to imprecise repair");
        }
        if (rangeSuperSet == null || !replicaSets.containsKey(rangeSuperSet)) {
            return Collections.emptySet();
        }
        HashSet<InetAddress> neighbors = new HashSet<InetAddress>((Collection)replicaSets.get(rangeSuperSet));
        neighbors.remove(FBUtilities.getBroadcastAddress());
        if (dataCenters != null) {
            TokenMetadata.Topology topology = ss.getTokenMetadata().cloneOnlyTokenMap().getTopology();
            HashSet<InetAddress> dcEndpoints = Sets.newHashSet();
            Multimap<String, InetAddress> dcEndpointsMap = topology.getDatacenterEndpoints();
            for (String dc : dataCenters) {
                Collection<InetAddress> c = dcEndpointsMap.get(dc);
                if (c == null) continue;
                dcEndpoints.addAll(c);
            }
            return Sets.intersection(neighbors, dcEndpoints);
        }
        if (hosts != null) {
            HashSet<InetAddress> specifiedHost = new HashSet<InetAddress>();
            for (String host : hosts) {
                try {
                    InetAddress endpoint = InetAddress.getByName(host.trim());
                    if (!endpoint.equals(FBUtilities.getBroadcastAddress()) && !neighbors.contains(endpoint)) continue;
                    specifiedHost.add(endpoint);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Unknown host specified " + host, e);
                }
            }
            if (!specifiedHost.contains(FBUtilities.getBroadcastAddress())) {
                throw new IllegalArgumentException("The current host must be part of the repair");
            }
            if (specifiedHost.size() <= 1) {
                String msg = "Repair requires at least two endpoints that are neighbours before it can continue, the endpoint used for this repair is %s, other available neighbours are %s but these neighbours were not part of the supplied list of hosts to use during the repair (%s).";
                throw new IllegalArgumentException(String.format(msg, specifiedHost, neighbors, hosts));
            }
            specifiedHost.remove(FBUtilities.getBroadcastAddress());
            return specifiedHost;
        }
        return neighbors;
    }

    public synchronized UUID prepareForRepair(InetAddress coordinator, Set<InetAddress> endpoints, Collection<Range<Token>> ranges, List<ColumnFamilyStore> columnFamilyStores) {
        UUID parentRepairSession = UUIDGen.getTimeUUID();
        this.registerParentRepairSession(parentRepairSession, coordinator, columnFamilyStores, ranges);
        final CountDownLatch prepareLatch = new CountDownLatch(endpoints.size());
        final AtomicBoolean status = new AtomicBoolean(true);
        final Set<String> failedNodes = Collections.synchronizedSet(new HashSet());
        IAsyncCallbackWithFailure callback = new IAsyncCallbackWithFailure(){

            @Override
            public void response(MessageIn msg) {
                prepareLatch.countDown();
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }

            @Override
            public void onFailure(InetAddress from) {
                status.set(false);
                failedNodes.add(from.getHostAddress());
                prepareLatch.countDown();
            }
        };
        ArrayList<UUID> cfIds = new ArrayList<UUID>(columnFamilyStores.size());
        for (ColumnFamilyStore cfs : columnFamilyStores) {
            cfIds.add(cfs.metadata.cfId);
        }
        for (InetAddress neighbour : endpoints) {
            if (FailureDetector.instance.isAlive(neighbour)) {
                PrepareMessage message = new PrepareMessage(parentRepairSession, cfIds, ranges);
                MessageOut<RepairMessage> msg = message.createMessage();
                MessagingService.instance().sendRR(msg, neighbour, callback, TimeUnit.HOURS.toMillis(1L), true);
                continue;
            }
            status.set(false);
            failedNodes.add(neighbour.getHostAddress());
            prepareLatch.countDown();
        }
        try {
            prepareLatch.await(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            this.parentRepairSessions.remove(parentRepairSession);
            throw new RuntimeException("Did not get replies from all endpoints. List of failed endpoint(s): " + failedNodes.toString(), e);
        }
        if (!status.get()) {
            this.parentRepairSessions.remove(parentRepairSession);
            throw new RuntimeException("Did not get positive replies from all endpoints. List of failed endpoint(s): " + failedNodes.toString());
        }
        return parentRepairSession;
    }

    public synchronized void registerParentRepairSession(UUID parentRepairSession, InetAddress coordinator, List<ColumnFamilyStore> columnFamilyStores, Collection<Range<Token>> ranges) {
        if (!this.registeredForEndpointChanges) {
            Gossiper.instance.register(this);
            FailureDetector.instance.registerFailureDetectionEventListener(this);
            this.registeredForEndpointChanges = true;
        }
        this.cleanupOldParentRepairSessions();
        this.parentRepairSessions.put(parentRepairSession, new ParentRepairSession(coordinator, columnFamilyStores, ranges, System.currentTimeMillis()));
    }

    private void cleanupOldParentRepairSessions() {
        long currentTime = System.currentTimeMillis();
        HashSet expired = new HashSet();
        for (Map.Entry entry : this.parentRepairSessions.entrySet()) {
            ParentRepairSession session = (ParentRepairSession)entry.getValue();
            if (!session.failed || currentTime - session.repairedAt <= TimeUnit.HOURS.toMillis(24L)) continue;
            expired.add(entry.getKey());
        }
        for (UUID remove : expired) {
            this.parentRepairSessions.remove(remove);
        }
    }

    public Set<SSTableReader> currentlyRepairing(UUID cfId, UUID parentRepairSession) {
        HashSet<SSTableReader> repairing = new HashSet<SSTableReader>();
        for (Map.Entry entry : this.parentRepairSessions.entrySet()) {
            Set sstables = ((ParentRepairSession)entry.getValue()).getActiveSSTables(cfId);
            if (sstables == null || ((UUID)entry.getKey()).equals(parentRepairSession)) continue;
            repairing.addAll(sstables);
        }
        return repairing;
    }

    public synchronized ListenableFuture<?> finishParentSession(UUID parentSession, Set<InetAddress> neighbors, boolean doAntiCompaction) throws InterruptedException, ExecutionException {
        ArrayList<ListenableFuture<List<Object>>> tasks = new ArrayList<ListenableFuture<List<Object>>>(neighbors.size() + 1);
        for (InetAddress neighbor : neighbors) {
            AnticompactionTask task = new AnticompactionTask(parentSession, neighbor, doAntiCompaction);
            tasks.add(task);
            task.run();
        }
        if (doAntiCompaction) {
            tasks.add(this.doAntiCompaction(parentSession));
        } else {
            this.removeParentRepairSession(parentSession);
        }
        return Futures.successfulAsList(tasks);
    }

    public ParentRepairSession getParentRepairSession(UUID parentSessionId) {
        ParentRepairSession session = (ParentRepairSession)this.parentRepairSessions.get(parentSessionId);
        if (session != null && session.failed) {
            throw new RuntimeException("Parent repair session with id = " + parentSessionId + " has failed.");
        }
        return session;
    }

    public synchronized ParentRepairSession removeParentRepairSession(UUID parentSessionId) {
        return (ParentRepairSession)this.parentRepairSessions.remove(parentSessionId);
    }

    public ListenableFuture<List<Object>> doAntiCompaction(final UUID parentRepairSession) {
        assert (parentRepairSession != null);
        ParentRepairSession prs = this.getParentRepairSession(parentRepairSession);
        ArrayList futures = new ArrayList();
        for (Map.Entry<UUID, ColumnFamilyStore> columnFamilyStoreEntry : prs.columnFamilyStores.entrySet()) {
            Refs<SSTableReader> sstables = prs.getActiveRepairedSSTableRefsForAntiCompaction(columnFamilyStoreEntry.getKey());
            ColumnFamilyStore cfs = columnFamilyStoreEntry.getValue();
            futures.add(CompactionManager.instance.submitAntiCompaction(cfs, prs.ranges, sstables, prs.repairedAt));
        }
        ListenableFuture<List<Object>> allAntiCompactionResults = Futures.successfulAsList(futures);
        allAntiCompactionResults.addListener(new Runnable(){

            @Override
            public void run() {
                ActiveRepairService.this.removeParentRepairSession(parentRepairSession);
            }
        }, MoreExecutors.sameThreadExecutor());
        return allAntiCompactionResults;
    }

    public void handleMessage(InetAddress endpoint, RepairMessage message) {
        RepairJobDesc desc = message.desc;
        RepairSession session = (RepairSession)this.sessions.get(desc.sessionId);
        if (session == null) {
            return;
        }
        switch (message.messageType) {
            case VALIDATION_COMPLETE: {
                ValidationComplete validation = (ValidationComplete)message;
                session.validationComplete(desc, endpoint, validation.tree);
                break;
            }
            case SYNC_COMPLETE: {
                SyncComplete sync = (SyncComplete)message;
                session.syncComplete(desc, sync.nodes, sync.success);
                break;
            }
        }
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
    }

    @Override
    public void beforeChange(InetAddress endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void convict(InetAddress ep, double phi) {
        if (phi < 2.0 * DatabaseDescriptor.getPhiConvictThreshold() || this.parentRepairSessions.isEmpty()) {
            return;
        }
        HashSet toRemove = new HashSet();
        for (Map.Entry repairSessionEntry : this.parentRepairSessions.entrySet()) {
            if (!((ParentRepairSession)repairSessionEntry.getValue()).coordinator.equals(ep)) continue;
            toRemove.add(repairSessionEntry.getKey());
        }
        if (!toRemove.isEmpty()) {
            logger.debug("Failing {} in parent repair sessions", toRemove);
            for (UUID id : toRemove) {
                ParentRepairSession failed = (ParentRepairSession)this.parentRepairSessions.get(id);
                this.parentRepairSessions.replace(id, failed, failed.asFailed());
            }
        }
    }

    public static class ParentRepairSession {
        public final Map<UUID, ColumnFamilyStore> columnFamilyStores = new HashMap<UUID, ColumnFamilyStore>();
        public final Collection<Range<Token>> ranges;
        public final Map<UUID, Set<String>> sstableMap = new HashMap<UUID, Set<String>>();
        public final long repairedAt;
        public final InetAddress coordinator;
        public final boolean failed;
        private final Set<UUID> marked = new HashSet<UUID>();

        public ParentRepairSession(InetAddress coordinator, List<ColumnFamilyStore> columnFamilyStores, Collection<Range<Token>> ranges, long repairedAt, boolean failed) {
            this.coordinator = coordinator;
            for (ColumnFamilyStore cfs : columnFamilyStores) {
                this.columnFamilyStores.put(cfs.metadata.cfId, cfs);
                this.sstableMap.put(cfs.metadata.cfId, new HashSet());
            }
            this.ranges = ranges;
            this.repairedAt = repairedAt;
            this.failed = failed;
        }

        public ParentRepairSession(InetAddress coordinator, List<ColumnFamilyStore> columnFamilyStores, Collection<Range<Token>> ranges, long repairedAt) {
            this(coordinator, columnFamilyStores, ranges, repairedAt, false);
        }

        public synchronized Refs<SSTableReader> getActiveRepairedSSTableRefsForAntiCompaction(UUID cfId) {
            assert (this.marked.contains(cfId));
            ImmutableMap.Builder<SSTableReader, Ref<SSTableReader>> references = ImmutableMap.builder();
            Set<SSTableReader> sstables = this.getActiveSSTables(cfId);
            if (sstables == null) {
                throw new RuntimeException("Not possible to get sstables for anticompaction for " + cfId);
            }
            for (SSTableReader sstable : sstables) {
                Ref<SSTableReader> ref = sstable.tryRef();
                if (ref == null) {
                    this.sstableMap.get(cfId).remove(sstable.getFilename());
                    continue;
                }
                references.put(sstable, ref);
            }
            return new Refs<SSTableReader>(references.build());
        }

        public synchronized void markSSTablesRepairing(UUID cfId, UUID parentSessionId) {
            if (!this.marked.contains(cfId)) {
                List<SSTableReader> sstables = this.columnFamilyStores.get((Object)cfId).select(ColumnFamilyStore.UNREPAIRED_SSTABLES).sstables;
                Set<SSTableReader> currentlyRepairing = instance.currentlyRepairing(cfId, parentSessionId);
                if (!Sets.intersection(currentlyRepairing, Sets.newHashSet(sstables)).isEmpty()) {
                    logger.error("Cannot start multiple repair sessions over the same sstables");
                    throw new RuntimeException("Cannot start multiple repair sessions over the same sstables");
                }
                this.addSSTables(cfId, sstables);
                this.marked.add(cfId);
            }
        }

        private Set<SSTableReader> getActiveSSTables(UUID cfId) {
            if (this.failed) {
                return Collections.emptySet();
            }
            if (!this.columnFamilyStores.containsKey(cfId)) {
                return null;
            }
            Set<String> repairedSSTables = this.sstableMap.get(cfId);
            HashSet<SSTableReader> activeSSTables = new HashSet<SSTableReader>();
            HashSet<String> activeSSTableNames = new HashSet<String>();
            for (SSTableReader sstable : this.columnFamilyStores.get(cfId).getSSTables()) {
                if (!repairedSSTables.contains(sstable.getFilename())) continue;
                activeSSTables.add(sstable);
                activeSSTableNames.add(sstable.getFilename());
            }
            this.sstableMap.put(cfId, activeSSTableNames);
            return activeSSTables;
        }

        private void addSSTables(UUID cfId, Collection<SSTableReader> sstables) {
            for (SSTableReader sstable : sstables) {
                this.sstableMap.get(cfId).add(sstable.getFilename());
            }
        }

        public ParentRepairSession asFailed() {
            return new ParentRepairSession(this.coordinator, Collections.emptyList(), Collections.emptyList(), System.currentTimeMillis(), true);
        }

        public String toString() {
            return "ParentRepairSession{columnFamilyStores=" + this.columnFamilyStores + ", ranges=" + this.ranges + ", sstableMap=" + this.sstableMap + ", repairedAt=" + this.repairedAt + '}';
        }
    }

    public static enum Status {
        STARTED,
        SESSION_SUCCESS,
        SESSION_FAILED,
        FINISHED;

    }
}

