/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.$internal.com.google.common.collect.HashMultimap;
import org.apache.cassandra.$internal.com.google.common.collect.ImmutableSet;
import org.apache.cassandra.$internal.com.google.common.collect.Multimap;
import org.apache.cassandra.$internal.com.google.common.collect.Sets;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BiMultiValMap;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingRangeCalculatorService {
    public static final PendingRangeCalculatorService instance = new PendingRangeCalculatorService();
    private static Logger logger = LoggerFactory.getLogger(PendingRangeCalculatorService.class);
    private final JMXEnabledThreadPoolExecutor executor = new JMXEnabledThreadPoolExecutor(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new NamedThreadFactory("PendingRangeCalculator"), "internal");

    public PendingRangeCalculatorService() {
        this.executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
    }

    public Future<?> update() {
        return this.executor.submit(new PendingRangeTask());
    }

    public void blockUntilFinished() {
        while ((long)this.executor.getActiveCount() + this.executor.getPendingTasks() != 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void calculatePendingRanges(AbstractReplicationStrategy strategy, String keyspaceName) {
        TokenMetadata tm = StorageService.instance.getTokenMetadata();
        HashMultimap<Range<Token>, InetAddress> pendingRanges = HashMultimap.create();
        BiMultiValMap<Token, InetAddress> bootstrapTokens = tm.getBootstrapTokens();
        Set<InetAddress> leavingEndpoints = tm.getLeavingEndpoints();
        if (bootstrapTokens.isEmpty() && leavingEndpoints.isEmpty() && tm.getMovingEndpoints().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("No bootstrapping, leaving or moving nodes, and no relocating tokens -> empty pending ranges for {}", (Object)keyspaceName);
            }
            tm.setPendingRanges(keyspaceName, pendingRanges);
            return;
        }
        Multimap<InetAddress, Range<Token>> addressRanges = strategy.getAddressRanges();
        TokenMetadata allLeftMetadata = tm.cloneAfterAllLeft();
        HashSet<Range<Token>> affectedRanges = new HashSet<Range<Token>>();
        for (InetAddress endpoint : leavingEndpoints) {
            affectedRanges.addAll(addressRanges.get(endpoint));
        }
        TokenMetadata metadata = tm.cloneOnlyTokenMap();
        for (Range range : affectedRanges) {
            ImmutableSet<InetAddress> immutableSet = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, metadata));
            ImmutableSet<InetAddress> newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, allLeftMetadata));
            pendingRanges.putAll(range, Sets.difference(newEndpoints, immutableSet));
        }
        Multimap<InetAddress, Token> bootstrapAddresses = bootstrapTokens.inverse();
        for (InetAddress inetAddress : bootstrapAddresses.keySet()) {
            Collection<Token> tokens = bootstrapAddresses.get(inetAddress);
            allLeftMetadata.updateNormalTokens(tokens, inetAddress);
            for (Range<Token> range : strategy.getAddressRanges(allLeftMetadata).get(inetAddress)) {
                pendingRanges.put(range, inetAddress);
            }
            allLeftMetadata.removeEndpoint(inetAddress);
        }
        for (Pair<Token, InetAddress> pair : tm.getMovingEndpoints()) {
            HashSet<Range<Token>> moveAffectedRanges = new HashSet<Range<Token>>();
            InetAddress endpoint = (InetAddress)pair.right;
            for (Range<Token> range : strategy.getAddressRanges(allLeftMetadata).get(endpoint)) {
                moveAffectedRanges.add(range);
            }
            allLeftMetadata.updateNormalToken((Token)pair.left, endpoint);
            for (Range<Token> range : strategy.getAddressRanges(allLeftMetadata).get(endpoint)) {
                moveAffectedRanges.add(range);
            }
            for (Range<Token> range : moveAffectedRanges) {
                ImmutableSet<InetAddress> currentEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, metadata));
                ImmutableSet<InetAddress> newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)range.right, allLeftMetadata));
                Sets.SetView<InetAddress> difference = Sets.difference(newEndpoints, currentEndpoints);
                for (InetAddress address : difference) {
                    Collection<Range<Token>> newRanges = strategy.getAddressRanges(allLeftMetadata).get(address);
                    Collection oldRanges = strategy.getAddressRanges(metadata).get(address);
                    newRanges.removeAll(oldRanges);
                    for (Range<Token> newRange : newRanges) {
                        for (Range<Token> pendingRange : newRange.subtractAll(oldRanges)) {
                            pendingRanges.put(pendingRange, address);
                        }
                    }
                }
            }
            allLeftMetadata.removeEndpoint(endpoint);
        }
        tm.setPendingRanges(keyspaceName, pendingRanges);
        if (logger.isDebugEnabled()) {
            logger.debug("Pending ranges:\n" + (pendingRanges.isEmpty() ? "<empty>" : tm.printPendingRanges()));
        }
    }

    private static class PendingRangeTask
    implements Runnable {
        private PendingRangeTask() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            for (String keyspaceName : Schema.instance.getNonSystemKeyspaces()) {
                PendingRangeCalculatorService.calculatePendingRanges(Keyspace.open(keyspaceName).getReplicationStrategy(), keyspaceName);
            }
            logger.debug("finished calculation for {} keyspaces in {}ms", (Object)Schema.instance.getNonSystemKeyspaces().size(), (Object)(System.currentTimeMillis() - start));
        }
    }
}

