/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.time.Duration;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;

final class HttpServerMetricsHandler
extends ChannelDuplexHandler {
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final HttpServerMetricsRecorder recorder;

    HttpServerMetricsHandler(HttpServerMetricsRecorder recorder) {
        this.recorder = recorder;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            if (((HttpResponse)msg).status().equals((Object)HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            this.dataSentTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener(future -> {
                ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    String path = ops.path;
                    String method = ops.method().name();
                    String status = ops.status().codeAsText().toString();
                    this.recorder.recordDataSentTime(path, method, status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
                    if (this.dataReceivedTime != 0L) {
                        this.recorder.recordResponseTime(path, method, status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
                    } else {
                        this.recorder.recordResponseTime(path, method, status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
                    }
                    this.recorder.recordDataSent(ops.remoteAddress(), path, this.dataSent);
                    this.dataSent = 0L;
                }
            });
        }
        ctx.write(msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            this.dataReceivedTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
            if (channelOps instanceof HttpServerOperations) {
                HttpServerOperations ops = (HttpServerOperations)channelOps;
                String path = ops.path;
                String method = ops.method().name();
                this.recorder.recordDataReceivedTime(path, method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
                this.recorder.recordDataReceived(ops.remoteAddress(), path, this.dataReceived);
            }
            this.dataReceived = 0L;
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpServerOperations) {
            HttpServerOperations ops = (HttpServerOperations)channelOps;
            this.recorder.incrementErrorsCount(ops.remoteAddress(), ops.path);
        }
        ctx.fireExceptionCaught(cause);
    }
}

