/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics.registry.compact;

import io.seata.metrics.Clock;
import io.seata.metrics.Id;
import io.seata.metrics.Measurement;
import io.seata.metrics.Summary;
import io.seata.metrics.SystemClock;
import io.seata.metrics.registry.compact.SummaryValue;
import java.util.Arrays;

public class CompactSummary
implements Summary {
    private final Id id;
    private final Id countId;
    private final Id totalId;
    private final Id tpsId;
    private volatile SummaryValue value;
    private final Clock clock;

    public CompactSummary(Id id) {
        this(id, SystemClock.INSTANCE);
    }

    public CompactSummary(Id id, Clock clock) {
        this.id = id;
        this.countId = new Id(id.getName()).withTag(id.getTags()).withTag("statistic", "count");
        this.totalId = new Id(id.getName()).withTag(id.getTags()).withTag("statistic", "total");
        this.tpsId = new Id(id.getName()).withTag(id.getTags()).withTag("statistic", "tps");
        this.value = new SummaryValue(clock.getCurrentMilliseconds());
        this.clock = clock;
    }

    public Id getId() {
        return this.id;
    }

    public void increase(long value) {
        this.value.increase(value);
    }

    public long total() {
        return this.value.getTotal();
    }

    public long count() {
        return this.value.getCount();
    }

    public double tps() {
        return this.value.getTps(this.clock.getCurrentMilliseconds());
    }

    public Iterable<Measurement> measure() {
        SummaryValue value = this.value;
        double time = this.clock.getCurrentMilliseconds();
        this.value = new SummaryValue(time);
        return Arrays.asList(new Measurement(this.countId, time, (double)value.getCount()), new Measurement(this.totalId, time, (double)value.getTotal()), new Measurement(this.tpsId, time, value.getTps(time)));
    }
}

