/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.ruby;

import io.vertx.core.AsyncResult;
import io.vertx.lang.ruby.AdaptingMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;

public class Helper {
    public static Map adaptingMap(Map map, Function toRuby, Function toJava) {
        if (map == null) {
            return null;
        }
        return new AdaptingMap(map, toRuby, toJava);
    }

    public static <T> AsyncResult<T> succeededResult(final T object) {
        return new AsyncResult<T>(){

            public T result() {
                return object;
            }

            public Throwable cause() {
                return null;
            }

            public boolean succeeded() {
                return true;
            }

            public boolean failed() {
                return false;
            }
        };
    }

    public static <T> AsyncResult<T> failedResult(final Object err) {
        return new AsyncResult<T>(){

            public T result() {
                return null;
            }

            public Throwable cause() {
                return err instanceof Throwable ? (Throwable)err : new Exception(String.valueOf(err));
            }

            public boolean succeeded() {
                return false;
            }

            public boolean failed() {
                return true;
            }
        };
    }

    public static Throwable catchAndReturnThrowable(Callable<?> c) {
        try {
            c.call();
        }
        catch (Throwable t) {
            return t;
        }
        throw new AssertionError((Object)"Should not happen");
    }
}

