/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.mongo;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.GridFsDownloadOptions;
import io.vertx.ext.mongo.GridFsUploadOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.ReadStreamSubscriber;
import java.util.List;

@RxGen(value=io.vertx.ext.mongo.MongoGridFsClient.class)
public class MongoGridFsClient {
    public static final TypeArg<MongoGridFsClient> __TYPE_ARG = new TypeArg(obj -> new MongoGridFsClient((io.vertx.ext.mongo.MongoGridFsClient)obj), MongoGridFsClient::getDelegate);
    private final io.vertx.ext.mongo.MongoGridFsClient delegate;
    private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_2 = new TypeArg(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoGridFsClient that = (MongoGridFsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoGridFsClient(io.vertx.ext.mongo.MongoGridFsClient delegate) {
        this.delegate = delegate;
    }

    public MongoGridFsClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoGridFsClient)delegate;
    }

    public io.vertx.ext.mongo.MongoGridFsClient getDelegate() {
        return this.delegate;
    }

    public Completable delete(String id) {
        Completable ret = this.rxDelete(id);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDelete(String id) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.delete(id, resultHandler));
    }

    public ReadStream<io.vertx.rxjava3.core.buffer.Buffer> readByFileName(String fileName) {
        ReadStream<io.vertx.rxjava3.core.buffer.Buffer> ret = ReadStream.newInstance(this.delegate.readByFileName(fileName), TYPE_ARG_0);
        return ret;
    }

    public ReadStream<io.vertx.rxjava3.core.buffer.Buffer> readByFileNameWithOptions(String fileName, GridFsDownloadOptions options) {
        ReadStream<io.vertx.rxjava3.core.buffer.Buffer> ret = ReadStream.newInstance(this.delegate.readByFileNameWithOptions(fileName, options), TYPE_ARG_1);
        return ret;
    }

    public ReadStream<io.vertx.rxjava3.core.buffer.Buffer> readById(String id) {
        ReadStream<io.vertx.rxjava3.core.buffer.Buffer> ret = ReadStream.newInstance(this.delegate.readById(id), TYPE_ARG_2);
        return ret;
    }

    public Single<Long> downloadByFileName(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> stream, String fileName) {
        Single ret = this.rxDownloadByFileName(stream, fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadByFileName(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.downloadByFileName(stream.getDelegate(), fileName, resultHandler));
    }

    public Single<Long> downloadByFileNameWithOptions(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> stream, String fileName, GridFsDownloadOptions options) {
        Single ret = this.rxDownloadByFileNameWithOptions(stream, fileName, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadByFileNameWithOptions(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> stream, String fileName, GridFsDownloadOptions options) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.downloadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler));
    }

    public Single<Long> downloadById(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> stream, String id) {
        Single ret = this.rxDownloadById(stream, id);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadById(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> stream, String id) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.downloadById(stream.getDelegate(), id, resultHandler));
    }

    public Single<Long> downloadFile(String fileName) {
        Single ret = this.rxDownloadFile(fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadFile(String fileName) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.downloadFile(fileName, resultHandler));
    }

    public Single<Long> downloadFileAs(String fileName, String newFileName) {
        Single ret = this.rxDownloadFileAs(fileName, newFileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadFileAs(String fileName, String newFileName) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.downloadFileAs(fileName, newFileName, resultHandler));
    }

    public Single<Long> downloadFileByID(String id, String fileName) {
        Single ret = this.rxDownloadFileByID(id, fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadFileByID(String id, String fileName) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.downloadFileByID(id, fileName, resultHandler));
    }

    public Completable drop() {
        Completable ret = this.rxDrop();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDrop() {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.drop(resultHandler));
    }

    public Single<List<String>> findAllIds() {
        Single ret = this.rxFindAllIds();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxFindAllIds() {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.findAllIds(resultHandler));
    }

    public Single<List<String>> findIds(JsonObject query) {
        Single ret = this.rxFindIds(query);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxFindIds(JsonObject query) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.findIds(query, resultHandler));
    }

    public Single<String> uploadByFileName(Flowable<io.vertx.rxjava3.core.buffer.Buffer> stream, String fileName) {
        Single ret = this.rxUploadByFileName(stream, fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxUploadByFileName(Flowable<io.vertx.rxjava3.core.buffer.Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.uploadByFileName(ReadStreamSubscriber.asReadStream((Flowable)stream, obj -> obj.getDelegate()).resume(), fileName, resultHandler));
    }

    public Single<String> uploadByFileNameWithOptions(Flowable<io.vertx.rxjava3.core.buffer.Buffer> stream, String fileName, GridFsUploadOptions options) {
        Single ret = this.rxUploadByFileNameWithOptions(stream, fileName, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxUploadByFileNameWithOptions(Flowable<io.vertx.rxjava3.core.buffer.Buffer> stream, String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.uploadByFileNameWithOptions(ReadStreamSubscriber.asReadStream((Flowable)stream, obj -> obj.getDelegate()).resume(), fileName, options, resultHandler));
    }

    public Single<String> uploadFile(String fileName) {
        Single ret = this.rxUploadFile(fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxUploadFile(String fileName) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.uploadFile(fileName, resultHandler));
    }

    public Single<String> uploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        Single ret = this.rxUploadFileWithOptions(fileName, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxUploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.uploadFileWithOptions(fileName, options, resultHandler));
    }

    public void close() {
        this.delegate.close();
    }

    public static MongoGridFsClient newInstance(io.vertx.ext.mongo.MongoGridFsClient arg) {
        return arg != null ? new MongoGridFsClient(arg) : null;
    }
}

