/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.function.Suppliers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultComponent
extends ServiceSupport
implements Component {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultComponent.class);
    private static final Pattern RAW_PATTERN = Pattern.compile("RAW[({].*&&.*[)}]");
    private static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/configurer/";
    private volatile PropertyConfigurer componentPropertyConfigurer;
    private volatile PropertyConfigurer endpointPropertyConfigurer;
    private final List<Supplier<ComponentExtension>> extensions = new ArrayList<Supplier<ComponentExtension>>();
    private CamelContext camelContext;
    @Metadata(label="advanced", description="Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities")
    private boolean basicPropertyBinding;
    @Metadata(label="consumer", description="Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.")
    private boolean bridgeErrorHandler;
    @Metadata(label="producer", description="Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.")
    private boolean lazyStartProducer;

    public DefaultComponent() {
    }

    public DefaultComponent(CamelContext context) {
        this.camelContext = context;
    }

    public Endpoint createEndpoint(String uri, Map<String, Object> properties) throws Exception {
        Map parameters;
        String encodedUri = UnsafeUriCharactersEncoder.encode((String)uri);
        URI u = new URI(encodedUri);
        String path = u.getScheme() != null ? URISupport.extractRemainderPath((URI)u, (boolean)this.useRawUri()) : null;
        if (this.useRawUri()) {
            int idx = uri.indexOf(63);
            String query = idx > -1 ? uri.substring(idx + 1) : u.getRawQuery();
            parameters = URISupport.parseQuery((String)query, (boolean)true);
        } else {
            parameters = URISupport.parseParameters((URI)u);
        }
        if (properties != null) {
            parameters.putAll(properties);
        }
        parameters.remove("hash");
        URISupport.resolveRawParameterValues((Map)parameters);
        this.validateURI(uri, path, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating endpoint uri=[{}], path=[{}], parameters=[{}]", new Object[]{URISupport.sanitizeUri((String)uri), URISupport.sanitizePath((String)path), parameters});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Creating endpoint uri=[{}], path=[{}]", (Object)URISupport.sanitizeUri((String)uri), (Object)URISupport.sanitizePath((String)path));
        }
        boolean basic = this.getAndRemoveParameter(parameters, "basicPropertyBinding", Boolean.TYPE, this.basicPropertyBinding ? this.basicPropertyBinding : this.getCamelContext().getGlobalEndpointConfiguration().isBasicPropertyBinding());
        boolean bridge = this.getAndRemoveParameter(parameters, "bridgeErrorHandler", Boolean.TYPE, this.bridgeErrorHandler ? this.bridgeErrorHandler : this.getCamelContext().getGlobalEndpointConfiguration().isBridgeErrorHandler());
        boolean lazy = this.getAndRemoveParameter(parameters, "lazyStartProducer", Boolean.TYPE, this.lazyStartProducer ? this.lazyStartProducer : this.getCamelContext().getGlobalEndpointConfiguration().isLazyStartProducer());
        Endpoint endpoint = this.createEndpoint(uri, path, parameters);
        if (endpoint == null) {
            return null;
        }
        endpoint.setCamelContext(this.getCamelContext());
        if (endpoint instanceof DefaultEndpoint) {
            DefaultEndpoint de = (DefaultEndpoint)endpoint;
            de.setBasicPropertyBinding(basic);
            de.setBridgeErrorHandler(bridge);
            de.setLazyStartProducer(lazy);
        }
        this.setProperties(endpoint, (Map<String, Object>)parameters);
        if (!endpoint.isLenientProperties()) {
            this.validateParameters(uri, parameters, null);
        }
        this.afterConfiguration(uri, path, endpoint, parameters);
        return endpoint;
    }

    public Endpoint createEndpoint(String uri) throws Exception {
        Map parameters;
        String encodedUri = UnsafeUriCharactersEncoder.encode((String)uri);
        URI u = new URI(encodedUri);
        String path = u.getScheme() != null ? URISupport.extractRemainderPath((URI)u, (boolean)this.useRawUri()) : null;
        if (this.useRawUri()) {
            int idx = uri.indexOf(63);
            String query = idx > -1 ? uri.substring(idx + 1) : u.getRawQuery();
            parameters = URISupport.parseQuery((String)query, (boolean)true);
        } else {
            parameters = URISupport.parseParameters((URI)u);
        }
        URISupport.resolveRawParameterValues((Map)parameters);
        uri = this.useRawUri() ? uri : encodedUri;
        this.validateURI(uri, path, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating endpoint uri=[{}], path=[{}], parameters=[{}]", new Object[]{URISupport.sanitizeUri((String)uri), URISupport.sanitizePath((String)path), parameters});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Creating endpoint uri=[{}], path=[{}]", (Object)URISupport.sanitizeUri((String)uri), (Object)URISupport.sanitizePath((String)path));
        }
        boolean basic = this.getAndRemoveParameter(parameters, "basicPropertyBinding", Boolean.TYPE, this.basicPropertyBinding ? this.basicPropertyBinding : this.getCamelContext().getGlobalEndpointConfiguration().isBasicPropertyBinding());
        boolean bridge = this.getAndRemoveParameter(parameters, "bridgeErrorHandler", Boolean.TYPE, this.bridgeErrorHandler ? this.bridgeErrorHandler : this.getCamelContext().getGlobalEndpointConfiguration().isBridgeErrorHandler());
        boolean lazy = this.getAndRemoveParameter(parameters, "lazyStartProducer", Boolean.TYPE, this.lazyStartProducer ? this.lazyStartProducer : this.getCamelContext().getGlobalEndpointConfiguration().isLazyStartProducer());
        Endpoint endpoint = this.createEndpoint(uri, path, parameters);
        if (endpoint == null) {
            return null;
        }
        endpoint.setCamelContext(this.getCamelContext());
        if (endpoint instanceof DefaultEndpoint) {
            DefaultEndpoint de = (DefaultEndpoint)endpoint;
            de.setBasicPropertyBinding(basic);
            de.setBridgeErrorHandler(bridge);
            de.setLazyStartProducer(lazy);
        }
        this.setProperties(endpoint, (Map<String, Object>)parameters);
        if (!endpoint.isLenientProperties()) {
            this.validateParameters(uri, parameters, null);
        }
        if (endpoint instanceof AfterPropertiesConfigured) {
            ((AfterPropertiesConfigured)endpoint).afterPropertiesConfigured(this.getCamelContext());
        }
        this.afterConfiguration(uri, path, endpoint, parameters);
        return endpoint;
    }

    public boolean useRawUri() {
        return false;
    }

    public boolean isBasicPropertyBinding() {
        return this.basicPropertyBinding;
    }

    public void setBasicPropertyBinding(boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public boolean isLazyStartProducer() {
        return this.lazyStartProducer;
    }

    public void setLazyStartProducer(boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public boolean isBridgeErrorHandler() {
        return this.bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        Map param = parameters;
        if (optionPrefix != null) {
            param = PropertiesHelper.extractProperties(parameters, (String)optionPrefix);
        }
        if (param.size() > 0) {
            throw new ResolveEndpointFailedException(uri, "There are " + param.size() + " parameters that couldn't be set on the endpoint. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown parameters=[" + param + "]");
        }
    }

    protected void validateURI(String uri, String path, Map<String, Object> parameters) {
        Matcher m;
        if (uri.contains("&&") && !(m = RAW_PATTERN.matcher(uri)).find()) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Double && marker found. Check the uri and remove the duplicate & marker.");
        }
        if (uri.endsWith("&")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    protected void doBuild() throws Exception {
        org.apache.camel.spi.annotations.Component ann = (org.apache.camel.spi.annotations.Component)ObjectHelper.getAnnotation((Object)((Object)this), org.apache.camel.spi.annotations.Component.class);
        if (ann != null) {
            String name = ann.value();
            if (name.contains(",")) {
                name = StringHelper.before((String)name, (String)",");
            }
            String componentConfigurerName = name + "-component-configurer";
            this.componentPropertyConfigurer = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(componentConfigurerName, this.getCamelContext());
            String endpointConfigurerName = name + "-endpoint-configurer";
            this.endpointPropertyConfigurer = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(endpointConfigurerName, this.getCamelContext());
        }
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
    }

    protected void doStop() throws Exception {
    }

    protected abstract Endpoint createEndpoint(String var1, String var2, Map<String, Object> var3) throws Exception;

    protected void setProperties(Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        endpoint.configureProperties(parameters);
    }

    protected void setProperties(Object bean, Map<String, Object> parameters) throws Exception {
        this.setProperties(this.getCamelContext(), bean, parameters);
    }

    protected void setProperties(CamelContext camelContext, Object bean, Map<String, Object> parameters) throws Exception {
        boolean basic;
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        boolean bl = basic = this.basicPropertyBinding || "true".equals(parameters.getOrDefault("basicPropertyBinding", "false"));
        if (basic) {
            PropertyBindingSupport.build().withPlaceholder(false).withNesting(false).withDeepNesting(false).withReference(false).bind(camelContext, bean, parameters);
        } else {
            Object configurer = bean instanceof Component ? this.getComponentPropertyConfigurer() : (bean instanceof Endpoint ? this.getEndpointPropertyConfigurer() : (bean instanceof PropertyConfigurerAware ? ((PropertyConfigurerAware)bean).getPropertyConfigurer(bean) : null));
            PropertyBindingSupport.build().withConfigurer((PropertyConfigurer)configurer).bind(camelContext, bean, parameters);
        }
    }

    public PropertyConfigurer getComponentPropertyConfigurer() {
        return this.componentPropertyConfigurer;
    }

    public PropertyConfigurer getEndpointPropertyConfigurer() {
        return this.endpointPropertyConfigurer;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return true;
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        Object value = parameters.remove(key);
        if (value != null) {
            return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
        }
        value = defaultValue;
        if (value == null) {
            return null;
        }
        return CamelContextHelper.mandatoryConvertTo(this.getCamelContext(), type, value);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveOrResolveReferenceParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        if (EndpointHelper.isReferenceParameter(value)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), value, type);
        }
        return (T)this.getCamelContext().getTypeConverter().convertTo(type, (Object)value);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.resolveAndRemoveReferenceParameter(parameters, key, type, null);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), value, type);
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType) {
        return this.resolveAndRemoveReferenceListParameter(parameters, key, elementType, new ArrayList(0));
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType, List<T> defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        return EndpointHelper.resolveReferenceListParameter(this.getCamelContext(), value, elementType);
    }

    protected String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }

    protected void registerExtension(ComponentExtension extension) {
        this.extensions.add(() -> extension);
    }

    protected void registerExtension(Supplier<ComponentExtension> supplier) {
        this.extensions.add(Suppliers.memorize(supplier));
    }

    public Collection<Class<? extends ComponentExtension>> getSupportedExtensions() {
        return this.extensions.stream().map(Supplier::get).map(Object::getClass).collect(Collectors.toList());
    }

    public <T extends ComponentExtension> Optional<T> getExtension(Class<T> extensionType) {
        return this.extensions.stream().map(Supplier::get).filter(extensionType::isInstance).findFirst().map(extensionType::cast).map(e -> (ComponentExtension)Component.trySetComponent((Object)e, (Component)this)).map(e -> (ComponentExtension)CamelContextAware.trySetCamelContext((Object)e, (CamelContext)this.getCamelContext()));
    }
}

