/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.AllowAllHostnameVerifier;
import org.apache.commons.httpclient.protocol.BrowserCompatHostnameVerifier;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.X509HostnameVerifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog(SSLProtocolSocketFactory.class);
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    private X509HostnameVerifier hostnameVerifier = SSLProtocolSocketFactory.getDefaultHostnameVerifier();
    private static final SSLProtocolSocketFactory factory = new SSLProtocolSocketFactory();

    public static SSLProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sslSocket = (SSLSocket)sf.createSocket(host, port, clientHost, clientPort);
        this.hostnameVerifier.verify(host, sslSocket);
        return sslSocket;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return this.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = ReflectionSocketFactory.createSocket("javax.net.ssl.SSLSocketFactory", host, port, localAddress, localPort, timeout);
        if (socket == null) {
            socket = ControllerThreadSocketFactory.createSocket(this, host, port, localAddress, localPort, timeout);
        }
        this.hostnameVerifier.verify(host, (SSLSocket)socket);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sslSocket = (SSLSocket)sf.createSocket(host, port);
        this.hostnameVerifier.verify(host, sslSocket);
        return sslSocket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket sslSocket = (SSLSocket)sf.createSocket(socket, host, port, autoClose);
        this.hostnameVerifier.verify(host, sslSocket);
        return sslSocket;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public void setHostnameVerifier(X509HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("Hostname verifier may not be null");
        }
        this.hostnameVerifier = hostnameVerifier;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    private static X509HostnameVerifier getDefaultHostnameVerifier() {
        String className = System.getProperty("org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory.hostnameVerifier");
        if (className != null) {
            if (className.equalsIgnoreCase(BROWSER_COMPATIBLE_HOSTNAME_VERIFIER.toString())) {
                return BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
            }
            if (className.equalsIgnoreCase(ALLOW_ALL_HOSTNAME_VERIFIER.toString())) {
                return ALLOW_ALL_HOSTNAME_VERIFIER;
            }
            try {
                Class<?> clazz = Class.forName(className);
                if (X509HostnameVerifier.class.isAssignableFrom(clazz)) {
                    Object instance = clazz.newInstance();
                    return (X509HostnameVerifier)instance;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error setting host verifier", (Throwable)e);
            }
        }
        return BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
    }
}

