/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.site.module.SiteModule;
import org.apache.maven.doxia.site.module.manager.SiteModuleManager;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

public class DefaultSiteRenderer
extends AbstractLogEnabled
implements Renderer {
    private static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";
    private VelocityComponent velocity;
    private SiteModuleManager siteModuleManager;
    private Doxia doxia;
    private I18N i18n;

    public void render(File siteDirectory, File outputDirectory, SiteRenderingContext context) throws RendererException, IOException {
        this.render(siteDirectory, outputDirectory, context, DEFAULT_OUTPUT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(File siteDirectory, File outputDirectory, SiteRenderingContext context, String outputEncoding) throws RendererException, IOException {
        Iterator i = this.siteModuleManager.getSiteModules().iterator();
        while (i.hasNext()) {
            SiteModule module = (SiteModule)i.next();
            File moduleBasedir = new File(siteDirectory, module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            List docs = FileUtils.getFileNames((File)moduleBasedir, (String)("**/*." + module.getExtension()), null, (boolean)false);
            Iterator j = docs.iterator();
            while (j.hasNext()) {
                String doc = (String)j.next();
                String outputName = doc.substring(0, doc.indexOf(".") + 1) + "html";
                String fullPathDoc = new File(moduleBasedir, doc).getPath();
                SiteRendererSink sink = this.createSink(moduleBasedir, outputName);
                try {
                    FileReader reader = new FileReader(fullPathDoc);
                    this.doxia.parse((Reader)reader, module.getParserId(), (Sink)sink);
                    File outputFile = new File(outputDirectory, outputName);
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    this.generateDocument(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputEncoding), sink, context);
                }
                catch (ParserNotFoundException e) {
                    throw new RendererException("Error getting a parser for " + fullPathDoc + ": " + e.getMessage());
                }
                catch (ParseException e) {
                    this.getLogger().error("Error parsing " + fullPathDoc + ": " + e.getMessage(), (Throwable)e);
                }
                finally {
                    sink.flush();
                    sink.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(File siteDirectory, File outputDirectory, String module, String moduleExtension, String moduleParserId, SiteRenderingContext context, String outputEncoding) throws RendererException, IOException {
        List docs = FileUtils.getFileNames((File)siteDirectory, (String)("**/*." + moduleExtension), null, (boolean)false);
        Iterator j = docs.iterator();
        while (j.hasNext()) {
            String doc = (String)j.next();
            String outputName = doc.substring(0, doc.indexOf(".") + 1) + "html";
            String fullPathDoc = new File(siteDirectory, doc).getPath();
            SiteRendererSink sink = this.createSink(siteDirectory, outputName);
            try {
                FileReader reader = new FileReader(fullPathDoc);
                this.doxia.parse((Reader)reader, moduleParserId, (Sink)sink);
                File outputFile = new File(outputDirectory, outputName);
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                this.generateDocument(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), outputEncoding), sink, context);
            }
            catch (ParserNotFoundException e) {
                throw new RendererException("Error getting a parser for " + fullPathDoc + ": " + e.getMessage());
            }
            catch (ParseException e) {
                this.getLogger().error("Error parsing " + fullPathDoc + ": " + e.getMessage(), (Throwable)e);
            }
            finally {
                sink.flush();
                sink.close();
            }
        }
    }

    public void generateDocument(Writer writer, SiteRendererSink sink, SiteRenderingContext siteContext) throws RendererException {
        VelocityContext context = new VelocityContext();
        RenderingContext renderingContext = sink.getRenderingContext();
        String relativePath = renderingContext.getRelativePath();
        context.put("relativePath", (Object)relativePath);
        context.put("authors", (Object)sink.getAuthors());
        String title = "";
        if (siteContext.getDecoration().getName() != null) {
            title = siteContext.getDecoration().getName();
        } else if (siteContext.getDefaultWindowTitle() != null) {
            title = siteContext.getDefaultWindowTitle();
        }
        if (title.length() > 0) {
            title = title + " - ";
        }
        title = title + sink.getTitle();
        context.put("title", (Object)title);
        context.put("bodyContent", (Object)sink.getBody());
        context.put("decoration", (Object)siteContext.getDecoration());
        context.put("currentDate", (Object)new Date());
        context.put("dateFormat", (Object)new SimpleDateFormat());
        String currentFileName = PathTool.calculateLink((String)renderingContext.getOutputName(), (String)relativePath);
        currentFileName = currentFileName.replace('\\', '/');
        context.put("currentFileName", (Object)currentFileName);
        context.put("locale", (Object)siteContext.getLocale());
        Map templateProperties = siteContext.getTemplateProperties();
        if (templateProperties != null) {
            Iterator i = templateProperties.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                context.put(key, templateProperties.get(key));
            }
        }
        context.put("PathTool", (Object)new PathTool());
        context.put("FileUtils", (Object)new FileUtils());
        context.put("StringUtils", (Object)new StringUtils());
        context.put("i18n", (Object)this.i18n);
        this.writeTemplate(siteContext.getTemplate(), writer, (Context)context, siteContext.getTemplateClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTemplate(String templateName, Writer writer, Context context, ClassLoader templateClassLoader) throws RendererException {
        ClassLoader old = null;
        if (templateClassLoader != null) {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(templateClassLoader);
        }
        try {
            this.processTemplate(templateName, context, writer);
        }
        finally {
            IOUtil.close((Writer)writer);
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    private void processTemplate(String templateName, Context context, Writer writer) throws RendererException {
        Template template;
        try {
            template = this.velocity.getEngine().getTemplate(templateName);
        }
        catch (Exception e) {
            throw new RendererException("Could not find the template '" + templateName);
        }
        try {
            template.merge(context, writer);
        }
        catch (Exception e) {
            throw new RendererException("Error while generating code.", e);
        }
    }

    public SiteRendererSink createSink(File moduleBaseDir, String document) {
        return new SiteRendererSink(new RenderingContext(moduleBaseDir, document));
    }
}

