/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.artifact.version;

import java.util.Collection;
import org.apache.maven.mercury.artifact.QualityRange;
import org.apache.maven.mercury.artifact.version.DefaultArtifactVersion;
import org.apache.maven.mercury.artifact.version.MavenVersionRange;
import org.apache.maven.mercury.artifact.version.VersionException;
import org.apache.maven.mercury.artifact.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionRangeFactory {
    public static VersionRange create(String version) throws VersionException {
        return new MavenVersionRange(version);
    }

    public static VersionRange create(String version, QualityRange qRange) throws VersionException {
        return new MavenVersionRange(version, qRange);
    }

    public static final String findLatest(Collection<String> versions, boolean noSnapshots) {
        DefaultArtifactVersion tempDav = null;
        DefaultArtifactVersion tempDav2 = null;
        String version = null;
        for (String vn : versions) {
            if (noSnapshots && vn.endsWith("SNAPSHOT")) continue;
            if (version == null) {
                version = vn;
                tempDav = new DefaultArtifactVersion(vn);
                continue;
            }
            tempDav2 = new DefaultArtifactVersion(vn);
            if (tempDav2.compareTo(tempDav) <= 0) continue;
            version = vn;
            tempDav = tempDav2;
        }
        return version;
    }
}

