/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.crypto.pgp;

import java.io.InputStream;
import org.apache.maven.mercury.crypto.api.AbstractStreamVerifierFactory;
import org.apache.maven.mercury.crypto.api.StreamVerifier;
import org.apache.maven.mercury.crypto.api.StreamVerifierAttributes;
import org.apache.maven.mercury.crypto.api.StreamVerifierException;
import org.apache.maven.mercury.crypto.api.StreamVerifierFactory;
import org.apache.maven.mercury.crypto.pgp.PgpHelper;
import org.apache.maven.mercury.crypto.pgp.PgpStreamVerifier;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class PgpStreamVerifierFactory
extends AbstractStreamVerifierFactory
implements StreamVerifierFactory {
    public static final String DEFAULT_EXTENSION = "asc";
    private static final Language lang = new DefaultLanguage(PgpStreamVerifierFactory.class);
    private PGPPublicKeyRingCollection trustedPublicKeyRing;
    private PGPPrivateKey privateKey;
    private int algorithm = 0;
    private int digestAlgorithm = 2;

    public PgpStreamVerifierFactory(StreamVerifierAttributes attributes, InputStream trustedPublicKeyRingStream) throws StreamVerifierException {
        super(attributes);
        this.init(trustedPublicKeyRingStream);
    }

    public PgpStreamVerifierFactory(StreamVerifierAttributes attributes, InputStream secretKeyRingStream, String secretKeyId, String secretKeyPass) throws StreamVerifierException {
        super(attributes);
        this.init(secretKeyRingStream, secretKeyId, secretKeyPass);
    }

    public void init(InputStream trustedPublicKeyRingStream) throws StreamVerifierException {
        block4: {
            try {
                if (trustedPublicKeyRingStream != null) {
                    this.trustedPublicKeyRing = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)trustedPublicKeyRingStream));
                    if (this.trustedPublicKeyRing == null) {
                        throw new StreamVerifierException(lang.getMessage("bad.factory.init.verify.empty", new String[0]));
                    }
                    break block4;
                }
                throw new StreamVerifierException(lang.getMessage("bad.factory.init.verify", new String[0]));
            }
            catch (Exception e) {
                throw new StreamVerifierException((Throwable)e);
            }
        }
    }

    public void init(InputStream secretKeyRingStream, String secretKeyId, String secretKeyPass) throws StreamVerifierException {
        try {
            if (secretKeyRingStream == null || secretKeyId == null || secretKeyPass == null) {
                throw new StreamVerifierException(lang.getMessage("bad.factory.init.generate", new String[0]));
            }
            PGPSecretKeyRing secRing = PgpHelper.readKeyRing(secretKeyRingStream, secretKeyId);
            PGPSecretKey secKey = secRing.getSecretKey(PgpHelper.hexToId(secretKeyId));
            this.privateKey = secKey.extractPrivateKey(secretKeyPass.toCharArray(), "BC");
            this.algorithm = secKey.getPublicKey().getAlgorithm();
        }
        catch (Exception e) {
            throw new StreamVerifierException((Throwable)e);
        }
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public StreamVerifier newInstance() throws StreamVerifierException {
        PgpStreamVerifier sv = new PgpStreamVerifier(this.attributes);
        if (this.privateKey != null) {
            sv.init(this.privateKey, this.algorithm, this.digestAlgorithm);
        }
        if (this.trustedPublicKeyRing != null) {
            sv.init(this.trustedPublicKeyRing);
        }
        return sv;
    }
}

