/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.event;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.maven.mercury.event.MercuryEvent;
import org.apache.maven.mercury.event.MercuryEventListener;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    public static final int THREAD_COUNT = 4;
    public static final String SYSTEM_PROPERTY_EVENT_MASK = "maven.mercury.events";
    public static final String systemPropertyEventMask = System.getProperty("maven.mercury.events", null);
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(EventManager.class);
    private static final Language _lang = new DefaultLanguage(EventManager.class);
    final List<MercuryEventListener> _listeners = new ArrayList<MercuryEventListener>(8);
    final LinkedBlockingQueue<UnitOfWork> _queue = new LinkedBlockingQueue(512);
    private ExecutorService _execService = Executors.newFixedThreadPool(4);
    private MercuryEvent.EventMask _eventMask;

    public EventManager() {
        for (int i = 0; i < 4; ++i) {
            this._execService.execute(new Runner(this._queue));
        }
        this.processSystemOptions();
    }

    public EventManager(MercuryEvent.EventMask eventMask) {
        this();
        this._eventMask = eventMask;
        this.processSystemOptions();
    }

    private final void processSystemOptions() {
        if (systemPropertyEventMask == null) {
            return;
        }
        if (this._eventMask == null) {
            this._eventMask = new MercuryEvent.EventMask(systemPropertyEventMask);
        } else {
            this._eventMask.setBits(systemPropertyEventMask);
        }
    }

    public void register(MercuryEventListener listener) {
        MercuryEvent.EventMask lMask = listener.getMask();
        if (lMask == null || this._eventMask == null || this._eventMask.intersects(lMask)) {
            this._listeners.add(listener);
        }
    }

    public void unRegister(MercuryEventListener listener) {
        this._listeners.remove(listener);
    }

    public List<MercuryEventListener> getListeners() {
        return this._listeners;
    }

    public void fireEvent(MercuryEvent event) {
        for (MercuryEventListener listener : this._listeners) {
            this._queue.add(new UnitOfWork(listener, event));
        }
    }

    public static final String toString(MercuryEvent event) {
        return new Date(event.getStart()) + ", dur: " + event.getDuration() + " millis :" + " [" + (Object)((Object)event.getType()) + ":" + event.getName() + "] " + (EventManager.isEmpty(event.getTag()) ? "" : ", tag: " + event.getTag()) + (EventManager.isEmpty(event.getInfo()) ? "" : ", info: " + event.getInfo()) + (EventManager.isEmpty(event.getResult()) ? "" : ", result: " + event.getResult());
    }

    public static final boolean isEmpty(String o) {
        return o == null || o.length() < 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Runner
    implements Runnable {
        final LinkedBlockingQueue<UnitOfWork> queue;

        public Runner(LinkedBlockingQueue<UnitOfWork> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    UnitOfWork uow = this.queue.take();
                    uow.execute();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    class UnitOfWork {
        MercuryEventListener listener;
        MercuryEvent event;

        public UnitOfWork(MercuryEventListener listener, MercuryEvent event) {
            this.listener = listener;
            this.event = event;
        }

        void execute() {
            try {
                MercuryEvent.EventMask lMask = this.listener.getMask();
                if (EventManager.this._eventMask != null) {
                    if (lMask == null) {
                        lMask = EventManager.this._eventMask;
                    } else {
                        lMask.and(EventManager.this._eventMask);
                    }
                }
                if (lMask == null || lMask.get(this.event.getType().bitNo)) {
                    this.listener.fire(this.event);
                }
            }
            catch (Throwable th) {
                _log.error(_lang.getMessage("listener.error", new String[]{th.getMessage()}));
            }
        }
    }
}

