/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.logging;

import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.IMercuryLoggerFactory;
import org.apache.maven.mercury.logging.MercuryLoggingLevelEnum;
import org.apache.maven.mercury.logging.console.MercuryConsoleLoggerFactory;

public class MercuryLoggerManager {
    public static final String SYSTEM_PROPERTY_MERCURY_LOG_FACTORY = "maven.mercury.log.factory";
    public static final String _loggerFactoryClassName = System.getProperty("maven.mercury.log.factory", MercuryConsoleLoggerFactory.class.getName());
    public static final String SYSTEM_PROPERTY_MERCURY_LOG_THRESHOLD = "maven.mercury.log.threshold";
    public static final String _loggerThresholdName = System.getProperty("maven.mercury.log.threshold", MercuryLoggingLevelEnum.error.name());
    static MercuryLoggingLevelEnum _threshold = MercuryLoggingLevelEnum.valueOf(_loggerThresholdName);
    static IMercuryLoggerFactory _loggerFactory;

    public static final IMercuryLogger getLogger(Class clazz) {
        if (_loggerFactory == null) {
            try {
                _loggerFactory = (IMercuryLoggerFactory)Class.forName(_loggerFactoryClassName).newInstance();
            }
            catch (Exception e) {
                _loggerFactory = new MercuryConsoleLoggerFactory();
                _loggerFactory.getLogger(MercuryLoggerManager.class).error("cannot load logger for " + _loggerFactoryClassName, e);
            }
        }
        return _loggerFactory.getLogger(clazz);
    }

    public static MercuryLoggingLevelEnum getThreshold() {
        return _threshold;
    }
}

