/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.metadata.sat;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.ArtifactMetadata;
import org.apache.maven.mercury.event.EventManager;
import org.apache.maven.mercury.event.EventTypeEnum;
import org.apache.maven.mercury.event.GenericEvent;
import org.apache.maven.mercury.event.MercuryEvent;
import org.apache.maven.mercury.event.MercuryEventListener;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.metadata.MetadataTreeNode;
import org.apache.maven.mercury.metadata.MetadataTreeNodeGAComparator;
import org.apache.maven.mercury.metadata.MetadataTreeNodeGAVComparator;
import org.apache.maven.mercury.metadata.sat.SatContext;
import org.apache.maven.mercury.metadata.sat.SatException;
import org.apache.maven.mercury.metadata.sat.SatHelper;
import org.apache.maven.mercury.metadata.sat.SatSolver;
import org.apache.maven.mercury.metadata.sat.SatVar;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSatSolver
implements SatSolver {
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(DefaultSatSolver.class);
    private static final Language _lang = new DefaultLanguage(DefaultSatSolver.class);
    protected SatContext _context;
    protected IPBSolver _solver = SolverFactory.newEclipseP2();
    protected MetadataTreeNode _root;
    protected EventManager _eventManager;
    protected static final Comparator<MetadataTreeNode> gaComparator = new MetadataTreeNodeGAComparator();

    public static SatSolver create(MetadataTreeNode tree) throws SatException {
        return new DefaultSatSolver(tree);
    }

    public static SatSolver create(MetadataTreeNode tree, EventManager eventManager) throws SatException {
        return new DefaultSatSolver(tree, eventManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultSatSolver(MetadataTreeNode tree, EventManager eventManager) throws SatException {
        this._eventManager = eventManager;
        GenericEvent event = null;
        if (tree == null) {
            throw new SatException("cannot create a solver for an empty [null] tree");
        }
        try {
            if (this._eventManager != null) {
                event = new GenericEvent(EventTypeEnum.satSolver, "create.sat.solver", tree.toString());
            }
            if (tree.getId() == 0) {
                MetadataTreeNode.reNumber(tree, 1);
            }
            int nNodes = tree.countDistinctNodes();
            _log.debug("SatContext: # of variables: " + nNodes);
            this._context = new SatContext(nNodes);
            this._solver.newVar(tree.countNodes());
            this._root = tree;
            try {
                this.addNode(tree);
            }
            catch (ContradictionException e) {
                throw new SatException(e);
            }
        }
        finally {
            if (this._eventManager != null) {
                event.stop();
                this._eventManager.fireEvent((MercuryEvent)event);
            }
        }
    }

    public DefaultSatSolver(MetadataTreeNode tree) throws SatException {
        this(tree, null);
    }

    @Override
    public final void applyPolicies(List<Comparator<MetadataTreeNode>> comparators) throws SatException {
        if (comparators == null || comparators.size() < 1) {
            return;
        }
        if (this._root == null) {
            throw new SatException("cannot apply policies to a null tree");
        }
        HashMap<String, List<MetadataTreeNode>> buckets = new HashMap<String, List<MetadataTreeNode>>(128);
        DefaultSatSolver.fillBuckets(buckets, this._root);
        DefaultSatSolver.sortBuckets(buckets, comparators);
        this.useBuckets(buckets);
    }

    private void useBuckets(Map<String, List<MetadataTreeNode>> buckets) throws SatException {
        if (buckets == null || buckets.size() < 1) {
            return;
        }
        VecInt vars = new VecInt(128);
        Vec coeffs = new Vec(128);
        int count = 0;
        for (String key : buckets.keySet()) {
            boolean bigBucket;
            List<MetadataTreeNode> bucket = buckets.get(key);
            int bucketSize = bucket.size();
            boolean bl = bigBucket = bucketSize > 1;
            if (_log.isDebugEnabled()) {
                _log.debug("\n\nBucket " + key);
            }
            VecInt bucketVars = new VecInt(bucketSize);
            for (int i = 0; i < bucketSize; ++i) {
                MetadataTreeNode n = bucket.get(i);
                if (_log.isDebugEnabled()) {
                    _log.debug(n.toString());
                }
                SatVar var = this._context.findOrAdd(n);
                int varLiteral = var.getLiteral();
                bucketVars.push(varLiteral);
                if (!bigBucket) continue;
                vars.push(varLiteral);
                long cf = (long)Math.pow(2.0, count++);
                coeffs.push((Object)BigInteger.valueOf(cf));
                if (!_log.isDebugEnabled()) continue;
                _log.debug("    " + cf + " x" + var.getLiteral());
            }
            try {
                if (bucketVars != null && !bucketVars.isEmpty()) {
                    this._solver.addAtMost((IVecInt)bucketVars, 1);
                    this._solver.addAtLeast((IVecInt)bucketVars, 1);
                }
            }
            catch (ContradictionException e) {
                throw new SatException(e);
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug("\n");
        }
        if (vars.isEmpty()) {
            return;
        }
        this._solver.setObjectiveFunction(new ObjectiveFunction((IVecInt)vars, (IVec)coeffs));
    }

    protected static final void sortBuckets(Map<String, List<MetadataTreeNode>> buckets, List<Comparator<MetadataTreeNode>> comparators) {
        for (List<MetadataTreeNode> bucket : buckets.values()) {
            Comparator<MetadataTreeNode> lastComparator = gaComparator;
            for (Comparator<MetadataTreeNode> comparator : comparators) {
                DefaultSatSolver.sortBucket(bucket, comparator, lastComparator);
                lastComparator = comparator;
            }
            Collections.reverse(bucket);
            DefaultSatSolver.removeDuplicateGAVs(bucket);
        }
    }

    protected static final void removeDuplicateGAVs(List<MetadataTreeNode> bucket) {
        int i;
        if (bucket == null || bucket.size() < 2) {
            return;
        }
        MetadataTreeNodeGAVComparator gav = new MetadataTreeNodeGAVComparator();
        int len = bucket.size();
        int[] dups = new int[len - 1];
        int cnt = 0;
        block0: for (i = 1; i < len; ++i) {
            MetadataTreeNode ti = bucket.get(i);
            for (int j = 0; j < i; ++j) {
                if (gav.compare(ti, bucket.get(j)) != 0) continue;
                dups[cnt++] = i;
                continue block0;
            }
        }
        if (cnt > 0) {
            for (i = 0; i < cnt; ++i) {
                bucket.remove(dups[cnt - i - 1]);
            }
        }
    }

    protected static final void sortBucket(List<MetadataTreeNode> bucket, Comparator<MetadataTreeNode> comparator, Comparator<MetadataTreeNode> lastComparator) {
        int i;
        if (bucket == null || bucket.size() < 2) {
            return;
        }
        int bLen = bucket.size();
        MetadataTreeNode[] temp = bucket.toArray(new MetadataTreeNode[bLen]);
        int wStart = -1;
        int wLen = 0;
        MetadataTreeNode[] work = new MetadataTreeNode[bLen];
        MetadataTreeNode lastNode = null;
        for (i = 0; i < bLen; ++i) {
            MetadataTreeNode n = temp[i];
            if (lastNode == null) {
                lastNode = n;
                continue;
            }
            if (lastComparator.compare(lastNode, n) == 0) {
                if (wLen == 0) {
                    work[wLen++] = lastNode;
                    wStart = i - 1;
                }
                work[wLen++] = n;
                lastNode = n;
                if (i < bLen - 1) continue;
            }
            if (wLen > 0) {
                DefaultSatSolver.reorder(work, wLen, comparator);
                for (int j = 0; j < wLen; ++j) {
                    temp[wStart + j] = work[j];
                }
                wLen = 0;
                wStart = -1;
            }
            lastNode = n;
        }
        bucket.clear();
        for (i = 0; i < bLen; ++i) {
            bucket.add(temp[i]);
        }
    }

    private static final void reorder(MetadataTreeNode[] work, int wLen, Comparator<MetadataTreeNode> comparator) {
        int i;
        MetadataTreeNode[] temp = new MetadataTreeNode[wLen];
        for (i = 0; i < wLen; ++i) {
            temp[i] = work[i];
        }
        Arrays.sort(temp, comparator);
        for (i = 0; i < wLen; ++i) {
            work[i] = temp[i];
        }
    }

    protected static final void fillBuckets(Map<String, List<MetadataTreeNode>> buckets, MetadataTreeNode node) {
        String ga = node.getMd().getGA();
        List<MetadataTreeNode> bucket = buckets.get(ga);
        if (bucket == null) {
            bucket = new ArrayList<MetadataTreeNode>(32);
            buckets.put(ga, bucket);
        }
        bucket.add(node);
        if (!node.hasChildren()) {
            return;
        }
        for (MetadataTreeNode kid : node.getChildren()) {
            DefaultSatSolver.fillBuckets(buckets, kid);
        }
    }

    private final void addPB(IVecInt lits, IVec<BigInteger> coeff, boolean ge, BigInteger cardinality) throws ContradictionException {
        this._solver.addPseudoBoolean(lits, coeff, ge, cardinality);
        if (_log.isDebugEnabled()) {
            _log.debug("PB: ");
        }
        for (int i = 0; i < lits.size(); ++i) {
            String space;
            int co = Integer.parseInt("" + coeff.get(i));
            String sign = co < 0 ? "-" : "+";
            int val = Math.abs(co);
            String string = space = val == 1 ? "" : " ";
            if (!_log.isDebugEnabled()) continue;
            _log.debug(" " + sign + (val == 1 ? "" : Integer.valueOf(val)) + space + "x" + lits.get(i));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((ge ? " >= " : " < ") + " " + cardinality);
        }
    }

    private final Map<ArtifactBasicMetadata, List<MetadataTreeNode>> processChildren(List<ArtifactBasicMetadata> queries, List<MetadataTreeNode> children) throws SatException {
        if (queries == null || queries.size() < 1) {
            return null;
        }
        if (children == null || children.size() < 1) {
            throw new SatException("there are queries, but not results. Queries: " + queries);
        }
        HashMap<ArtifactBasicMetadata, List<MetadataTreeNode>> res = new HashMap<ArtifactBasicMetadata, List<MetadataTreeNode>>(queries.size());
        for (ArtifactBasicMetadata q : queries) {
            ArrayList<MetadataTreeNode> bucket = new ArrayList<MetadataTreeNode>(4);
            String queryGA = q.getGA();
            for (MetadataTreeNode tn : children) {
                if (tn.getMd() == null) {
                    throw new SatException("resulting tree node without metadata for query " + q);
                }
                if (!queryGA.equals(tn.getMd().getGA())) continue;
                bucket.add(tn);
            }
            if (bucket.size() < 1) {
                throw new SatException("No children for query " + queryGA);
            }
            res.put(q, bucket);
        }
        return res;
    }

    private final void addNode(MetadataTreeNode node) throws ContradictionException, SatException {
        if (node == null) {
            return;
        }
        if (node.getMd() == null) {
            throw new SatException("found a node without metadata");
        }
        SatVar nodeLit = this._context.findOrAdd(node);
        if (node.getParent() == null) {
            this.addPB(SatHelper.getSmallOnes(nodeLit.getLiteral()), SatHelper.getBigOnes(1, false), true, BigInteger.ONE);
        }
        if (!node.hasChildren()) {
            return;
        }
        Map<ArtifactBasicMetadata, List<MetadataTreeNode>> kids = this.processChildren(node.getQueries(), node.getChildren());
        if (kids == null) {
            return;
        }
        for (Map.Entry<ArtifactBasicMetadata, List<MetadataTreeNode>> kid : kids.entrySet()) {
            ArtifactBasicMetadata query = kid.getKey();
            List<MetadataTreeNode> range = kid.getValue();
            if (range.size() > 1) {
                this.addRange(nodeLit.getLiteral(), range, query.isOptional());
                for (MetadataTreeNode tn : range) {
                    this.addNode(tn);
                }
                continue;
            }
            MetadataTreeNode child = range.get(0);
            SatVar kidLit = this._context.findOrAdd(child);
            this.addPB(SatHelper.getSmallOnes(new int[]{nodeLit.getLiteral(), kidLit.getLiteral()}), SatHelper.getBigOnes(1, -1), true, BigInteger.ZERO);
            this.addNode(child);
        }
    }

    private final int[] addRange(int parentLiteral, List<MetadataTreeNode> range, boolean optional) throws ContradictionException, SatException {
        int[] literals = new int[range.size()];
        int count = 0;
        for (MetadataTreeNode tn : range) {
            SatVar literal = this._context.findOrAdd(tn);
            literals[count++] = literal.getLiteral();
            this.addPB(SatHelper.getSmallOnes(new int[]{parentLiteral, literal.getLiteral()}), SatHelper.getBigOnes(1, -1), true, BigInteger.ZERO);
        }
        IVecInt rangeVector = SatHelper.getSmallOnes(literals);
        if (optional) {
            if (_log.isDebugEnabled()) {
                _log.debug("optional range: atMost 1: " + SatHelper.vectorToString(rangeVector));
            }
            this._solver.addAtMost(rangeVector, 1);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug("range: " + SatHelper.vectorToString(rangeVector));
            }
            IConstr atLeast = this._solver.addAtLeast(rangeVector, 1);
            if (_log.isDebugEnabled()) {
                _log.debug("atLeast: " + SatHelper.vectorToString(atLeast));
            }
            IConstr atMost = this._solver.addAtMost(rangeVector, 1);
            if (_log.isDebugEnabled()) {
                _log.debug("atMost: " + SatHelper.vectorToString(atMost));
            }
        }
        return literals;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final List<ArtifactMetadata> solve() throws SatException {
        ArrayList<ArtifactMetadata> res = null;
        GenericEvent event = null;
        try {
            if (this._eventManager != null) {
                event = new GenericEvent(EventTypeEnum.satSolver, "solve", this._root.toString());
            }
            if (this._solver.isSatisfiable()) {
                res = new ArrayList<ArtifactMetadata>(this._root.countNodes());
                int[] model = this._solver.model();
                if (_log.isDebugEnabled()) {
                    if (model != null) {
                        StringBuilder sb = new StringBuilder();
                        String comma = "";
                        for (int m : model) {
                            sb.append(comma + m);
                            comma = ", ";
                        }
                        _log.debug('[' + sb.toString() + ']');
                    } else {
                        _log.debug("model is null");
                    }
                }
                for (int i : model) {
                    if (i <= 0) continue;
                    res.add(this._context.getMd(i));
                }
            }
            if (this._eventManager == null) return res;
        }
        catch (TimeoutException e) {
            try {
                throw new SatException(e);
            }
            catch (Throwable throwable) {
                if (this._eventManager == null) throw throwable;
                event.stop();
                this._eventManager.fireEvent(event);
                throw throwable;
            }
        }
        event.stop();
        this._eventManager.fireEvent((MercuryEvent)event);
        return res;
    }

    public final MetadataTreeNode solveAsTree() throws SatException {
        try {
            if (this._solver.isSatisfiable()) {
                int[] model = this._solver.model();
                if (_log.isDebugEnabled()) {
                    if (model != null) {
                        StringBuilder sb = new StringBuilder();
                        String comma = "";
                        for (int m : model) {
                            sb.append(comma + m);
                            comma = ", ";
                        }
                        _log.debug('[' + sb.toString() + ']');
                    } else {
                        _log.debug("model is null");
                    }
                }
                return this._context.getSolutionSubtree(this._root, model);
            }
            return null;
        }
        catch (TimeoutException e) {
            throw new SatException(e);
        }
    }

    public void register(MercuryEventListener listener) {
        if (this._eventManager == null) {
            this._eventManager = new EventManager();
        }
        this._eventManager.register(listener);
    }

    public void setEventManager(EventManager eventManager) {
        this._eventManager = eventManager;
    }

    public void unRegister(MercuryEventListener listener) {
        if (this._eventManager != null) {
            this._eventManager.unRegister(listener);
        }
    }
}

