/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.Snapshot;
import org.apache.maven.mercury.repository.metadata.Versioning;
import org.apache.maven.mercury.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.mercury.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.mercury.util.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataBuilder {
    public static Metadata read(InputStream in) throws MetadataException {
        try {
            return new MetadataXpp3Reader().read(in);
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    public static Metadata getMetadata(byte[] in) throws MetadataException {
        if (in == null || in.length < 10) {
            return null;
        }
        try {
            return new MetadataXpp3Reader().read(new ByteArrayInputStream(in));
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    public static Metadata write(Metadata metadata, OutputStream out) throws MetadataException {
        if (metadata == null) {
            return metadata;
        }
        try {
            new MetadataXpp3Writer().write(new OutputStreamWriter(out), metadata);
            return metadata;
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
    }

    public static byte[] changeMetadata(byte[] metadataBytes, List<MetadataOperation> mutators) throws MetadataException {
        Metadata metadata;
        if (mutators == null || mutators.size() < 1) {
            return metadataBytes;
        }
        boolean changed = false;
        if (metadataBytes == null || metadataBytes.length < 10) {
            metadata = new Metadata();
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(metadataBytes);
            metadata = MetadataBuilder.read(in);
        }
        for (MetadataOperation op : mutators) {
            changed = op.perform(metadata) || changed;
        }
        return MetadataBuilder.getBytes(metadata);
    }

    public static byte[] getBytes(Metadata metadata) throws MetadataException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MetadataBuilder.write(metadata, out);
        byte[] res = out.toByteArray();
        return res;
    }

    public static byte[] changeMetadata(Metadata metadata, List<MetadataOperation> mutators) throws MetadataException {
        boolean changed = false;
        if (metadata == null) {
            metadata = new Metadata();
        }
        if (mutators != null && mutators.size() > 0) {
            for (MetadataOperation op : mutators) {
                changed = op.perform(metadata) || changed;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MetadataBuilder.write(metadata, out);
        byte[] res = out.toByteArray();
        return res;
    }

    public static byte[] changeMetadata(byte[] metadataBytes, MetadataOperation op) throws MetadataException {
        ArrayList<MetadataOperation> ops = new ArrayList<MetadataOperation>(1);
        ops.add(op);
        return MetadataBuilder.changeMetadata(metadataBytes, ops);
    }

    public static byte[] changeMetadata(Metadata metadata, MetadataOperation op) throws MetadataException {
        ArrayList<MetadataOperation> ops = new ArrayList<MetadataOperation>(1);
        ops.add(op);
        return MetadataBuilder.changeMetadata(metadata, ops);
    }

    public static void updateTimestamp(Snapshot target) {
        target.setTimestamp(TimeUtil.getUTCTimestamp());
    }

    public static void updateTimestamp(Versioning target) {
        target.setLastUpdated(TimeUtil.getUTCTimestamp());
    }

    public static Snapshot createSnapshot(String version) {
        Snapshot sn = new Snapshot();
        if (version == null || version.length() < 3) {
            return sn;
        }
        String utc = TimeUtil.getUTCTimestamp();
        sn.setTimestamp(utc);
        if (version.endsWith("SNAPSHOT")) {
            return sn;
        }
        String sbn = version.substring(version.lastIndexOf(45) + 1);
        int bn = Integer.parseInt(sbn);
        sn.setBuildNumber(bn);
        return sn;
    }
}

