/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.metadata;

import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.Snapshot;
import org.apache.maven.mercury.repository.metadata.SnapshotOperand;
import org.apache.maven.mercury.repository.metadata.Versioning;
import org.apache.maven.mercury.util.TimeUtil;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class SetSnapshotOperation
implements MetadataOperation {
    private static final Language lang = new DefaultLanguage(SetSnapshotOperation.class);
    private Snapshot snapshot;

    public SetSnapshotOperation(SnapshotOperand data) throws MetadataException {
        this.setOperand(data);
    }

    public void setOperand(Object data) throws MetadataException {
        if (data == null || !(data instanceof SnapshotOperand)) {
            throw new MetadataException(lang.getMessage("bad.operand", new String[]{"SnapshotOperand", data == null ? "null" : data.getClass().getName()}));
        }
        this.snapshot = ((SnapshotOperand)data).getOperand();
    }

    public boolean perform(Metadata metadata) throws MetadataException {
        if (metadata == null) {
            return false;
        }
        Versioning vs = metadata.getVersioning();
        if (vs == null) {
            vs = new Versioning();
            metadata.setVersioning(vs);
        }
        vs.setSnapshot(this.snapshot);
        vs.setLastUpdated(TimeUtil.getUTCTimestamp());
        return true;
    }
}

