/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.format;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.PropertyUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;

public class FileFormatter {
    private final Logger logger;
    private final AssemblerConfigurationSource configSource;
    private Properties filterProperties;

    public FileFormatter(AssemblerConfigurationSource configSource, Logger logger) {
        this.configSource = configSource;
        this.logger = logger;
    }

    protected FileFormatter(Properties filterProperties, AssemblerConfigurationSource configSource, Logger logger) {
        this.filterProperties = filterProperties;
        this.configSource = configSource;
        this.logger = logger;
    }

    public File format(File source, boolean filter, String lineEnding) throws AssemblyFormattingException {
        File result = source;
        File tempRoot = this.configSource.getTemporaryRootDirectory();
        AssemblyFileUtils.verifyTempDirectoryAvailability(tempRoot, this.logger);
        String sourceName = source.getName();
        try {
            String rawContents;
            boolean contentIsChanged = false;
            String contents = rawContents = this.readFile(source);
            if (filter) {
                contents = this.filter(contents);
            }
            contentIsChanged = !contents.equals(rawContents);
            BufferedReader contentReader = new BufferedReader(new StringReader(contents));
            File tempFilterFile = FileUtils.createTempFile((String)(sourceName + "."), (String)".filtered", (File)tempRoot);
            boolean fileWritten = this.formatLineEndings(contentReader, tempFilterFile, lineEnding, contentIsChanged);
            if (fileWritten) {
                result = tempFilterFile;
            }
        }
        catch (FileNotFoundException e) {
            throw new AssemblyFormattingException("File to filter not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new AssemblyFormattingException("Error filtering file '" + source + "': " + e.getMessage(), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File source) throws IOException {
        FileReader fileReader = null;
        StringWriter contentWriter = new StringWriter();
        try {
            fileReader = new FileReader(source);
            IOUtil.copy((Reader)fileReader, (Writer)contentWriter);
        }
        catch (Throwable throwable) {
            IOUtil.close(fileReader);
            throw throwable;
        }
        IOUtil.close((Reader)fileReader);
        return contentWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean formatLineEndings(BufferedReader contentReader, File tempFilterFile, String lineEnding, boolean contentIsChanged) throws IOException, AssemblyFormattingException {
        boolean fileWritten = false;
        String lineEndingChars = AssemblyFileUtils.getLineEndingCharacters(lineEnding);
        if (lineEndingChars != null) {
            AssemblyFileUtils.convertLineEndings(contentReader, tempFilterFile, lineEndingChars);
            fileWritten = true;
        } else if (contentIsChanged) {
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(tempFilterFile);
                IOUtil.copy((Reader)contentReader, (Writer)fileWriter);
                fileWritten = true;
            }
            catch (Throwable throwable) {
                IOUtil.close(fileWriter);
                throw throwable;
            }
            IOUtil.close((Writer)fileWriter);
        }
        return fileWritten;
    }

    private String filter(String rawContents) throws AssemblyFormattingException {
        this.initializeFiltering();
        String contents = rawContents;
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)this.filterProperties));
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)this.configSource.getProject()));
        contents = interpolator.interpolate(contents, "project");
        return contents;
    }

    private void initializeFiltering() throws AssemblyFormattingException {
        this.logger.info("Initializing assembly filters...");
        if (this.filterProperties == null) {
            this.filterProperties = new Properties(System.getProperties());
            MavenProject project = this.configSource.getProject();
            ((Hashtable)this.filterProperties).putAll(project.getProperties());
            List filters = this.configSource.getFilters();
            if (filters != null && !filters.isEmpty()) {
                Iterator i = filters.iterator();
                while (i.hasNext()) {
                    String filtersfile = (String)i.next();
                    try {
                        Properties properties = PropertyUtils.getInterpolatedPropertiesFromFile(new File(filtersfile), true, true);
                        ((Hashtable)this.filterProperties).putAll(properties);
                    }
                    catch (IOException e) {
                        throw new AssemblyFormattingException("Error loading property file '" + filtersfile + "'", e);
                    }
                }
            }
        }
    }
}

