/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler.module;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaModuleDescriptor;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.compiler.module.JavaModuleDescriptor;
import org.apache.maven.plugin.compiler.module.ModuleInfoParser;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ModuleInfoParser.class, hint="qdox")
public class QDoxModuleInfoParser
implements ModuleInfoParser {
    @Override
    public ModuleInfoParser.Type getType() {
        return ModuleInfoParser.Type.SOURCE;
    }

    @Override
    public JavaModuleDescriptor getModuleDescriptor(File modulePath) throws IOException {
        JavaModuleDescriptor.Builder builder;
        File moduleDescriptor = new File(modulePath, "module-info.java");
        if (moduleDescriptor.exists()) {
            com.thoughtworks.qdox.model.JavaModuleDescriptor descriptor = new JavaProjectBuilder().addSourceFolder(modulePath).getDescriptor();
            builder = JavaModuleDescriptor.newModule(descriptor.getName());
            for (JavaModuleDescriptor.JavaRequires requires : descriptor.getRequires()) {
                builder.requires(requires.getModule().getName());
            }
            for (JavaModuleDescriptor.JavaExports exports : descriptor.getExports()) {
                builder.exports(exports.getSource().getName());
            }
        } else {
            builder = JavaModuleDescriptor.newAutomaticModule(null);
        }
        return builder.build();
    }
}

