/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Site;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.repository.Repository;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JxrReportUtil {
    private static final String MAVEN_JAVADOC_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final String MAVEN_JAVADOC_PLUGIN_ARTIFACT_ID = "maven-javadoc-plugin";

    protected static boolean isJavadocAggregated(MavenProject project) throws IOException {
        boolean javadocAggregate = Boolean.valueOf(JxrReportUtil.getMavenJavadocPluginBasicOption(project, "aggregate", "false"));
        if (javadocAggregate) {
            return true;
        }
        for (Object pluginObject : JxrReportUtil.getMavenJavadocPlugins(project)) {
            if (!(pluginObject instanceof Plugin)) continue;
            Plugin plugin = (Plugin)pluginObject;
            List executions = plugin.getExecutions();
            for (PluginExecution pe : executions) {
                List goals = pe.getGoals();
                for (String goal : goals) {
                    if (!"aggregate".equals(goal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected static String getMavenJavadocPluginBasicOption(MavenProject project, String optionName, String defaultValue) throws IOException {
        ArrayList plugins = new ArrayList();
        Iterator it = project.getModel().getReporting().getPlugins().iterator();
        while (it.hasNext()) {
            plugins.add(it.next());
        }
        it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            plugins.add(it.next());
        }
        String pluginArtifactId = MAVEN_JAVADOC_PLUGIN_ARTIFACT_ID;
        for (Object next : plugins) {
            Xpp3Dom pluginConf = null;
            if (next instanceof Plugin) {
                Plugin plugin = (Plugin)next;
                if (!JxrReportUtil.isReportPluginMavenJavadoc(pluginArtifactId, plugin)) continue;
                pluginConf = (Xpp3Dom)plugin.getConfiguration();
            }
            if (next instanceof ReportPlugin) {
                ReportPlugin reportPlugin = (ReportPlugin)next;
                if (!JxrReportUtil.isReportPluginJavaDocPlugin(pluginArtifactId, reportPlugin)) continue;
                pluginConf = (Xpp3Dom)reportPlugin.getConfiguration();
            }
            if (pluginConf == null) continue;
            try {
                StringInputStream stringInputStream = new StringInputStream(pluginConf.toString());
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)stringInputStream);
                XObject obj = XPathAPI.eval((Node)doc, (String)("//configuration/" + optionName));
                if (!StringUtils.isNotEmpty((String)obj.toString())) continue;
                return obj.toString();
            }
            catch (SAXException e) {
                throw new IOException("SAXException: " + e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new IOException("ParserConfigurationException: " + e.getMessage());
            }
            catch (FactoryConfigurationError e) {
                throw new IOException("FactoryConfigurationError: " + e.getMessage());
            }
            catch (TransformerException e) {
                throw new IOException("TransformerException: " + e.getMessage());
            }
        }
        return defaultValue;
    }

    protected static List<?> getMavenJavadocPlugins(MavenProject project) throws IOException {
        ArrayList plugins = new ArrayList();
        Iterator it = project.getModel().getReporting().getPlugins().iterator();
        while (it.hasNext()) {
            plugins.add(it.next());
        }
        it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            plugins.add(it.next());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        String pluginArtifactId = MAVEN_JAVADOC_PLUGIN_ARTIFACT_ID;
        for (Object next : plugins) {
            ReportPlugin reportPlugin;
            if (next instanceof Plugin) {
                Plugin plugin = (Plugin)next;
                if (!JxrReportUtil.isReportPluginMavenJavadoc(pluginArtifactId, plugin)) continue;
                result.add(plugin);
            }
            if (!(next instanceof ReportPlugin) || !JxrReportUtil.isReportPluginJavaDocPlugin(pluginArtifactId, reportPlugin = (ReportPlugin)next)) continue;
            result.add(reportPlugin);
        }
        return result;
    }

    private static boolean isReportPluginMavenJavadoc(String pluginArtifactId, Plugin plugin) {
        return plugin.getGroupId().equals(MAVEN_JAVADOC_PLUGIN_GROUP_ID) && plugin.getArtifactId().equals(pluginArtifactId);
    }

    private static boolean isReportPluginJavaDocPlugin(String pluginArtifactId, ReportPlugin reportPlugin) {
        return reportPlugin.getGroupId().equals(MAVEN_JAVADOC_PLUGIN_GROUP_ID) && reportPlugin.getArtifactId().equals(pluginArtifactId);
    }

    protected static String getStructure(MavenProject project, boolean ignoreMissingSiteUrl) throws IOException {
        if (project.getDistributionManagement() == null) {
            String hierarchy = project.getName();
            for (MavenProject parent = project.getParent(); parent != null; parent = parent.getParent()) {
                hierarchy = parent.getName() + '/' + hierarchy;
            }
            return hierarchy;
        }
        Site site = project.getDistributionManagement().getSite();
        if (site == null) {
            if (!ignoreMissingSiteUrl) {
                throw new IOException("Missing site information in the distribution management element in the project: '" + project.getName() + "'.");
            }
            return null;
        }
        if (StringUtils.isEmpty((String)site.getUrl())) {
            if (!ignoreMissingSiteUrl) {
                throw new IOException("The URL in the site is missing in the project descriptor.");
            }
            return null;
        }
        Repository repository = new Repository(site.getId(), site.getUrl());
        if (StringUtils.isEmpty((String)repository.getBasedir())) {
            return repository.getHost();
        }
        if (repository.getBasedir().startsWith("/")) {
            return repository.getHost() + repository.getBasedir();
        }
        return repository.getHost() + '/' + repository.getBasedir();
    }
}

