/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.sourceforge.pmd.PMD;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.pmd.PmdFileInfo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.bridge.SLF4JBridgeHandler;

public abstract class AbstractPmdReport
extends AbstractMavenReport {
    @Parameter(property="project.build.directory", required=true)
    protected File targetDirectory;
    @Parameter(property="project.reporting.outputDirectory", required=true)
    protected File outputDirectory;
    @Component
    private Renderer siteRenderer;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="format", defaultValue="xml")
    protected String format = "xml";
    @Parameter(property="linkXRef", defaultValue="true")
    private boolean linkXRef;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref")
    private File xrefLocation;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref-test")
    private File xrefTestLocation;
    @Parameter
    private List<String> excludes;
    @Parameter
    private List<String> includes;
    @Parameter(defaultValue="${project.compileSourceRoots}")
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.testCompileSourceRoots}")
    private List<String> testSourceRoots;
    @Parameter
    private File[] excludeRoots;
    @Parameter(defaultValue="false")
    protected boolean includeTests;
    @Parameter(property="aggregate", defaultValue="false")
    protected boolean aggregate;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String sourceEncoding;
    @Parameter(property="outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter(property="reactorProjects", readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(defaultValue="false")
    protected boolean includeXmlInSite;
    @Parameter(defaultValue="false")
    protected boolean skipEmptyReport;
    @Parameter(property="pmd.excludeFromFailureFile", defaultValue="")
    protected String excludeFromFailureFile;
    @Parameter(defaultValue="true", property="pmd.showPmdLog")
    protected boolean showPmdLog = true;
    private Logger julLogger;
    protected Map<File, PmdFileInfo> filesToProcess;

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String constructXRefLocation(boolean test) {
        String location = null;
        if (this.linkXRef) {
            File xrefLoc = test ? this.xrefTestLocation : this.xrefLocation;
            String relativePath = PathTool.getRelativePath((String)this.outputDirectory.getAbsolutePath(), (String)xrefLoc.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + xrefLoc.getName();
            if (xrefLoc.exists()) {
                location = relativePath;
            } else {
                List reportPlugins = this.project.getReportPlugins();
                for (ReportPlugin plugin : reportPlugins) {
                    String artifactId = plugin.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    protected Map<File, PmdFileInfo> getFilesToProcess() throws IOException {
        File sroot;
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return Collections.emptyMap();
        }
        if (this.excludeRoots == null) {
            this.excludeRoots = new File[0];
        }
        HashSet<File> excludeRootFiles = new HashSet<File>(this.excludeRoots.length);
        for (File file : this.excludeRoots) {
            if (!file.isDirectory()) continue;
            excludeRootFiles.add(file);
        }
        ArrayList<PmdFileInfo> directories = new ArrayList<PmdFileInfo>();
        if (null == this.compileSourceRoots) {
            this.compileSourceRoots = this.project.getCompileSourceRoots();
        }
        if (this.compileSourceRoots != null) {
            for (String root : this.compileSourceRoots) {
                sroot = new File(root);
                if (!sroot.exists()) continue;
                String sourceXref = this.constructXRefLocation(false);
                directories.add(new PmdFileInfo(this.project, sroot, sourceXref));
            }
        }
        if (null == this.testSourceRoots) {
            this.testSourceRoots = this.project.getTestCompileSourceRoots();
        }
        if (this.includeTests && this.testSourceRoots != null) {
            for (String root : this.testSourceRoots) {
                sroot = new File(root);
                if (!sroot.exists()) continue;
                String testXref = this.constructXRefLocation(true);
                directories.add(new PmdFileInfo(this.project, sroot, testXref));
            }
        }
        if (this.aggregate) {
            for (MavenProject localProject : this.reactorProjects) {
                Object root2;
                List localCompileSourceRoots = localProject.getCompileSourceRoots();
                for (Object root2 : localCompileSourceRoots) {
                    File sroot2 = new File((String)root2);
                    if (!sroot2.exists()) continue;
                    String sourceXref = this.constructXRefLocation(false);
                    directories.add(new PmdFileInfo(localProject, sroot2, sourceXref));
                }
                if (!this.includeTests) continue;
                List localTestCompileSourceRoots = localProject.getTestCompileSourceRoots();
                root2 = localTestCompileSourceRoots.iterator();
                while (root2.hasNext()) {
                    String root3 = (String)root2.next();
                    File sroot3 = new File(root3);
                    if (!sroot3.exists()) continue;
                    String testXref = this.constructXRefLocation(true);
                    directories.add(new PmdFileInfo(localProject, sroot3, testXref));
                }
            }
        }
        String excluding = this.getExcludes();
        this.getLog().debug((CharSequence)("Exclusions: " + excluding));
        String including = this.getIncludes();
        this.getLog().debug((CharSequence)("Inclusions: " + including));
        TreeMap<File, PmdFileInfo> files = new TreeMap<File, PmdFileInfo>();
        for (PmdFileInfo finfo : directories) {
            this.getLog().debug((CharSequence)("Searching for files in directory " + finfo.getSourceDirectory().toString()));
            File sourceDirectory = finfo.getSourceDirectory();
            if (!sourceDirectory.isDirectory() || this.isDirectoryExcluded(excludeRootFiles, sourceDirectory)) continue;
            List newfiles = FileUtils.getFiles((File)sourceDirectory, (String)including, (String)excluding);
            for (File newfile : newfiles) {
                files.put(newfile.getCanonicalFile(), finfo);
            }
        }
        return files;
    }

    private boolean isDirectoryExcluded(Collection<File> excludeRootFiles, File sourceDirectoryToCheck) {
        boolean returnVal = false;
        for (File excludeDir : excludeRootFiles) {
            try {
                if (!sourceDirectoryToCheck.getCanonicalPath().startsWith(excludeDir.getCanonicalPath())) continue;
                this.getLog().debug((CharSequence)("Directory " + sourceDirectoryToCheck.getAbsolutePath() + " has been excluded as it matches excludeRoot " + excludeDir.getAbsolutePath()));
                returnVal = true;
                break;
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Error while checking " + sourceDirectoryToCheck + " whether it should be excluded."), (Throwable)e);
            }
        }
        return returnVal;
    }

    private String getIncludes() {
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        if (this.includes != null) {
            patterns.addAll(this.includes);
        }
        if (patterns.isEmpty()) {
            patterns.add("**/*.java");
        }
        return StringUtils.join(patterns.iterator(), (String)",");
    }

    private String getExcludes() {
        LinkedHashSet<String> patterns = new LinkedHashSet<String>(FileUtils.getDefaultExcludesAsList());
        if (this.excludes != null) {
            patterns.addAll(this.excludes);
        }
        return StringUtils.join(patterns.iterator(), (String)",");
    }

    protected boolean isHtml() {
        return "html".equals(this.format);
    }

    protected boolean isXml() {
        return "xml".equals(this.format);
    }

    public boolean canGenerateReport() {
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return false;
        }
        if ("pom".equals(this.project.getPackaging()) && !this.aggregate) {
            return false;
        }
        if (this.isXml()) {
            return true;
        }
        try {
            this.filesToProcess = this.getFilesToProcess();
            if (this.filesToProcess.isEmpty()) {
                return false;
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
        return true;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected String getSourceEncoding() {
        return this.sourceEncoding;
    }

    protected String getOutputEncoding() {
        return this.outputEncoding != null ? this.outputEncoding : "UTF-8";
    }

    protected void setupPmdLogging() {
        if (!this.showPmdLog) {
            return;
        }
        Logger logger = Logger.getLogger("net.sourceforge.pmd");
        boolean slf4jBridgeAlreadyAdded = false;
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof SLF4JBridgeHandler)) continue;
            slf4jBridgeAlreadyAdded = true;
            break;
        }
        if (slf4jBridgeAlreadyAdded) {
            return;
        }
        SLF4JBridgeHandler handler = new SLF4JBridgeHandler();
        SimpleFormatter formatter = new SimpleFormatter();
        handler.setFormatter((Formatter)formatter);
        logger.setUseParentHandlers(false);
        logger.addHandler((Handler)handler);
        handler.setLevel(Level.ALL);
        logger.setLevel(Level.ALL);
        this.julLogger = logger;
        this.julLogger.fine("Configured jul-to-slf4j bridge for " + logger.getName());
    }

    static String getPmdVersion() {
        try {
            return (String)PMD.class.getField("VERSION").get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("PMD VERSION field not accessible", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("PMD VERSION field not found", e);
        }
    }
}

