/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.release.AbstractReleaseMojo;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;

public class PerformReleaseMojo
extends AbstractReleaseMojo {
    private String goals;
    private File workingDirectory;
    private String connectionUrl;
    private boolean useReleaseProfile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        try {
            ReleaseDescriptor releaseDescriptor = this.createReleaseDescriptor();
            if (this.connectionUrl != null) {
                releaseDescriptor.setScmSourceUrl(this.connectionUrl);
            }
            releaseDescriptor.setCheckoutDirectory(this.workingDirectory.getAbsolutePath());
            releaseDescriptor.setUseReleaseProfile(this.useReleaseProfile);
            if (this.goals == null) {
                this.goals = "deploy";
                if (this.project.getDistributionManagement() != null && this.project.getDistributionManagement().getSite() != null) {
                    this.goals = this.goals + " site-deploy";
                }
            }
            releaseDescriptor.setPerformGoals(this.goals);
            this.releaseManager.perform(releaseDescriptor, this.settings, this.reactorProjects);
        }
        catch (ReleaseExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ReleaseFailureException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }
}

