/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class ResourceBundleAppendingTransformer
implements ResourceTransformer {
    private Map<String, ByteArrayOutputStream> dataMap = new HashMap<String, ByteArrayOutputStream>();
    private Pattern resourceBundlePattern;
    private long time = Long.MIN_VALUE;

    public void setBasename(String basename) {
        this.resourceBundlePattern = Pattern.compile(basename + "(_[a-zA-Z]+){0,3}\\.properties");
    }

    @Override
    public boolean canTransformResource(String r) {
        return this.resourceBundlePattern != null && this.resourceBundlePattern.matcher(r).matches();
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        ByteArrayOutputStream data = this.dataMap.get(resource);
        if (data == null) {
            data = new ByteArrayOutputStream();
            this.dataMap.put(resource, data);
        }
        IOUtil.copy((InputStream)is, (OutputStream)data);
        data.write(10);
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.dataMap.isEmpty();
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (Map.Entry<String, ByteArrayOutputStream> dataEntry : this.dataMap.entrySet()) {
            JarEntry jarEntry = new JarEntry(dataEntry.getKey());
            jarEntry.setTime(this.time);
            jos.putNextEntry(jarEntry);
            jos.write(dataEntry.getValue().toByteArray());
            dataEntry.getValue().reset();
        }
    }
}

