/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.webapp;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;

public class DoxiaFilter
implements Filter {
    private Renderer siteRenderer;
    private SiteRenderingContext context;
    private Map documents;
    private File generatedSiteDirectory;
    private List originalSiteDirectories;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        this.siteRenderer = (Renderer)servletContext.getAttribute("siteRenderer");
        this.context = (SiteRenderingContext)servletContext.getAttribute("context");
        this.documents = (Map)servletContext.getAttribute("documents");
        this.generatedSiteDirectory = (File)servletContext.getAttribute("generatedSiteDirectory");
        this.originalSiteDirectories = new ArrayList(this.context.getSiteDirectories());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        String path = req.getServletPath();
        if (path.endsWith("/")) {
            path = path + "index.html";
        }
        if (this.documents.containsKey(path = path.substring(1))) {
            this.context.setLocale(req.getLocale());
            try {
                DocumentRenderer renderer = (DocumentRenderer)this.documents.get(path);
                renderer.renderDocument((Writer)servletResponse.getWriter(), this.siteRenderer, this.context);
            }
            catch (RendererException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (this.generatedSiteDirectory != null && this.generatedSiteDirectory.exists()) {
            this.context.getSiteDirectories().clear();
            this.context.addSiteDirectory(this.generatedSiteDirectory);
            try {
                Map documents = this.siteRenderer.locateDocumentFiles(this.context);
                if (documents.containsKey(path)) {
                    this.context.setLocale(req.getLocale());
                    DocumentRenderer renderer = (DocumentRenderer)documents.get(path);
                    renderer.renderDocument((Writer)servletResponse.getWriter(), this.siteRenderer, this.context);
                }
            }
            catch (RendererException e) {
                throw new ServletException((Throwable)e);
            }
            Iterator i = this.originalSiteDirectories.iterator();
            while (i.hasNext()) {
                File dir = (File)i.next();
                this.context.addSiteDirectory(dir);
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

