/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.toolchain.jdk;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.toolchain.jdk.ToolchainDiscoverer;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.RequirementMatcherFactory;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Mojo(name="select-jdk-toolchain", defaultPhase=LifecyclePhase.VALIDATE)
public class SelectJdkToolchainMojo
extends AbstractMojo {
    public static final String TOOLCHAIN_TYPE_JDK = "jdk";
    @Parameter(property="toolchain.jdk.version")
    private String version;
    @Parameter(property="toolchain.jdk.runtime.name")
    private String runtimeName;
    @Parameter(property="toolchain.jdk.runtime.version")
    private String runtimeVersion;
    @Parameter(property="toolchain.jdk.vendor")
    private String vendor;
    @Parameter(property="toolchain.jdk.env")
    private String env;
    @Parameter(property="toolchain.jdk.mode", defaultValue="IfMatch")
    private JdkMode useJdk = JdkMode.IfMatch;
    @Parameter(property="toolchain.jdk.discover", defaultValue="true")
    private boolean discoverToolchains = true;
    @Parameter(property="toolchain.jdk.comparator", defaultValue="lts,current,env,version,vendor")
    private String comparator;
    @Inject
    private ToolchainManagerPrivate toolchainManager;
    @Inject
    @Named(value="jdk")
    ToolchainFactory factory;
    @Inject
    private MavenSession session;
    @Inject
    ToolchainDiscoverer discoverer;

    public void execute() throws MojoFailureException {
        try {
            this.doExecute();
        }
        catch (MisconfiguredToolchainException e) {
            throw new MojoFailureException("Unable to select toolchain: " + (Object)((Object)e), (Throwable)e);
        }
    }

    private void doExecute() throws MisconfiguredToolchainException, MojoFailureException {
        ToolchainPrivate currentJdkToolchain;
        if (this.version == null && this.runtimeName == null && this.runtimeVersion == null && this.vendor == null && this.env == null) {
            return;
        }
        HashMap<String, String> requirements = new HashMap<String, String>();
        Optional.ofNullable(this.version).ifPresent(v -> requirements.put("version", (String)v));
        Optional.ofNullable(this.runtimeName).ifPresent(v -> requirements.put("runtime.name", (String)v));
        Optional.ofNullable(this.runtimeVersion).ifPresent(v -> requirements.put("runtime.version", (String)v));
        Optional.ofNullable(this.vendor).ifPresent(v -> requirements.put("vendor", (String)v));
        Optional.ofNullable(this.env).ifPresent(v -> requirements.put("env", (String)v));
        ToolchainModel currentJdkToolchainModel = this.discoverer.getCurrentJdkToolchain().orElse(null);
        ToolchainPrivate toolchainPrivate = currentJdkToolchain = currentJdkToolchainModel != null ? this.factory.createToolchain(currentJdkToolchainModel) : null;
        if (this.useJdk == JdkMode.IfMatch && currentJdkToolchain != null && this.matches(currentJdkToolchain, requirements)) {
            this.getLog().info((CharSequence)"Not using an external toolchain as the current JDK matches the requirements.");
            return;
        }
        ToolchainPrivate toolchain = Stream.of(this.toolchainManager.getToolchainsForType(TOOLCHAIN_TYPE_JDK, this.session)).filter(tc -> this.matches((ToolchainPrivate)tc, (Map<String, String>)requirements)).findFirst().orElse(null);
        if (toolchain != null) {
            this.getLog().info((CharSequence)("Found matching JDK toolchain: " + toolchain));
        }
        if (toolchain == null && this.discoverToolchains) {
            this.getLog().debug((CharSequence)"No matching toolchains configured, trying to discover JDK toolchains");
            PersistedToolchains persistedToolchains = this.discoverer.discoverToolchains(this.comparator);
            this.getLog().debug((CharSequence)("Discovered " + persistedToolchains.getToolchains().size() + " JDK toolchains"));
            for (ToolchainModel tcm : persistedToolchains.getToolchains()) {
                ToolchainPrivate tc2 = this.factory.createToolchain(tcm);
                if (tc2 == null || !this.matches(tc2, requirements)) continue;
                toolchain = tc2;
                this.getLog().debug((CharSequence)("Discovered matching JDK toolchain: " + toolchain));
                break;
            }
        }
        if (toolchain == null) {
            throw new MojoFailureException("Cannot find matching toolchain definitions for the following toolchain types:" + requirements + System.lineSeparator() + "Define the required toolchains in your ~/.m2/toolchains.xml file.");
        }
        if (this.useJdk == JdkMode.IfSame && currentJdkToolchain != null && Objects.equals(this.getJdkHome(currentJdkToolchain), this.getJdkHome(toolchain))) {
            this.getLog().debug((CharSequence)"Not using an external toolchain as the current JDK has been selected.");
            return;
        }
        this.toolchainManager.storeToolchainToBuildContext(toolchain, this.session);
        this.getLog().debug((CharSequence)("Found matching JDK toolchain: " + toolchain));
    }

    private boolean matches(ToolchainPrivate tc, Map<String, String> requirements) {
        ToolchainModel model = tc.getModel();
        for (Map.Entry<String, String> req : requirements.entrySet()) {
            String key = req.getKey();
            String reqVal = req.getValue();
            String tcVal = model.getProvides().getProperty(key);
            if (tcVal == null) {
                this.getLog().debug((CharSequence)("Toolchain " + tc + " is missing required property: " + key));
                return false;
            }
            if (this.matches(key, reqVal, tcVal)) continue;
            this.getLog().debug((CharSequence)("Toolchain " + tc + " doesn't match required property: " + key));
            return false;
        }
        return true;
    }

    private boolean matches(String key, String reqVal, String tcVal) {
        switch (key) {
            case "version": {
                return RequirementMatcherFactory.createVersionMatcher((String)tcVal).matches(reqVal);
            }
            case "env": {
                return reqVal.matches("(.*,|^)\\Q" + tcVal + "\\E(,.*|$)");
            }
        }
        return RequirementMatcherFactory.createExactMatcher((String)tcVal).matches(reqVal);
    }

    private String getJdkHome(ToolchainPrivate toolchain) {
        return ((Xpp3Dom)toolchain.getModel().getConfiguration()).getChild("jdkHome").getValue();
    }

    public static enum JdkMode {
        Never,
        IfSame,
        IfMatch;

    }
}

