/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractReleasePomsPhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.util.IOUtil;

public class GenerateReleasePomsPhase
extends AbstractReleasePomsPhase {
    private PathTranslator pathTranslator;
    private Map scmTranslators;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, settings, reactorProjects, false);
    }

    private ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean simulate) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        if (releaseDescriptor.isGenerateReleasePoms()) {
            this.logInfo(result, "Generating release POMs...");
            this.generateReleasePoms(releaseDescriptor, settings, reactorProjects, simulate, result);
        } else {
            this.logInfo(result, "Not generating release POMs");
        }
        result.setResultCode(0);
        return result;
    }

    private void generateReleasePoms(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean simulate, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        ArrayList<File> releasePoms = new ArrayList<File>();
        Iterator iterator = reactorProjects.iterator();
        while (iterator.hasNext()) {
            MavenProject project = (MavenProject)iterator.next();
            this.logInfo(result, "Generating release POM for '" + project.getName() + "'...");
            releasePoms.add(this.generateReleasePom(project, releaseDescriptor, settings, reactorProjects, simulate, result));
        }
        this.addReleasePomsToScm(releaseDescriptor, settings, reactorProjects, simulate, result, releasePoms);
    }

    private File generateReleasePom(MavenProject project, ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean simulate, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        Model releasePom = this.createReleaseModel(project, releaseDescriptor, settings, reactorProjects, result);
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        File releasePomFile = ReleaseUtil.getReleasePom(project);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(releasePomFile);
            pomWriter.write((Writer)fileWriter, releasePom);
        }
        catch (IOException exception) {
            try {
                throw new ReleaseExecutionException("Cannot generate release POM", exception);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileWriter);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fileWriter);
        return releasePomFile;
    }

    private void addReleasePomsToScm(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean simulate, ReleaseResult result, List releasePoms) throws ReleaseFailureException, ReleaseExecutionException {
        if (simulate) {
            this.logInfo(result, "Full run would be adding " + releasePoms);
        } else {
            ScmRepository scmRepository = this.getScmRepository(releaseDescriptor, settings);
            ScmProvider scmProvider = this.getScmProvider(scmRepository);
            MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
            ScmFileSet scmFileSet = new ScmFileSet(rootProject.getFile().getParentFile(), releasePoms);
            try {
                AddScmResult scmResult = scmProvider.add(scmRepository, scmFileSet);
                if (!scmResult.isSuccess()) {
                    throw new ReleaseScmCommandException("Cannot add release POM to SCM", (ScmResult)scmResult);
                }
            }
            catch (ScmException exception) {
                throw new ReleaseExecutionException("Cannot add release POM to SCM: " + exception.getMessage(), exception);
            }
        }
    }

    private Model createReleaseModel(MavenProject project, ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, ReleaseResult result) throws ReleaseFailureException, ReleaseExecutionException {
        Map originalVersions = this.getOriginalVersionMap(releaseDescriptor, reactorProjects);
        Map mappedVersions = this.getNextVersionMap(releaseDescriptor);
        MavenProject releaseProject = new MavenProject(project);
        Model releaseModel = releaseProject.getModel();
        releaseModel.setParent(null);
        releaseModel.setProfiles(Collections.EMPTY_LIST);
        releaseModel.setDependencyManagement(null);
        releaseProject.getBuild().setPluginManagement(null);
        String projectVersion = releaseModel.getVersion();
        String releaseVersion = this.getNextVersion(mappedVersions, project.getGroupId(), project.getArtifactId(), projectVersion);
        releaseModel.setVersion(releaseVersion);
        String finalName = releaseModel.getBuild().getFinalName();
        if (finalName.equals(releaseModel.getArtifactId() + "-" + projectVersion)) {
            releaseModel.getBuild().setFinalName(null);
        } else if (finalName.indexOf("SNAPSHOT") != -1) {
            throw new ReleaseFailureException("Cannot reliably adjust the finalName of project: " + releaseProject.getId());
        }
        Scm scm = releaseModel.getScm();
        if (scm != null) {
            ScmRepository scmRepository = this.getScmRepository(releaseDescriptor, settings);
            ScmTranslator scmTranslator = this.getScmTranslator(scmRepository);
            if (scmTranslator != null) {
                releaseModel.setScm(this.createReleaseScm(releaseModel.getScm(), scmTranslator, releaseDescriptor));
            } else {
                String message = "No SCM translator found - skipping rewrite";
                result.appendDebug(message);
                this.getLogger().debug(message);
            }
        }
        releaseModel.setDependencies(this.createReleaseDependencies(originalVersions, mappedVersions, releaseProject));
        releaseModel.getBuild().setPlugins(this.createReleasePlugins(originalVersions, mappedVersions, releaseProject));
        releaseModel.getReporting().setPlugins(this.createReleaseReportPlugins(originalVersions, mappedVersions, releaseProject));
        releaseModel.getBuild().setExtensions(this.createReleaseExtensions(originalVersions, mappedVersions, releaseProject));
        this.pathTranslator.unalignFromBaseDirectory(releaseProject.getModel(), project.getFile().getParentFile());
        return releaseModel;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, settings, reactorProjects, true);
    }

    protected Map getOriginalVersionMap(ReleaseDescriptor releaseDescriptor, List reactorProjects) {
        return releaseDescriptor.getOriginalVersions(reactorProjects);
    }

    protected Map getNextVersionMap(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getReleaseVersions();
    }

    private String getNextVersion(Map mappedVersions, String groupId, String artifactId, String version) throws ReleaseFailureException {
        String id = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        String nextVersion = (String)mappedVersions.get(id);
        if (nextVersion == null) {
            throw new ReleaseFailureException("Version for '" + id + "' was not mapped");
        }
        return nextVersion;
    }

    private ScmTranslator getScmTranslator(ScmRepository scmRepository) {
        return (ScmTranslator)this.scmTranslators.get(scmRepository.getProvider());
    }

    private Scm createReleaseScm(Scm scm, ScmTranslator scmTranslator, ReleaseDescriptor releaseDescriptor) {
        String value;
        String tag = releaseDescriptor.getScmReleaseLabel();
        String tagBase = releaseDescriptor.getScmTagBase();
        Scm releaseScm = new Scm();
        if (scm.getConnection() != null) {
            value = scmTranslator.translateTagUrl(scm.getConnection(), tag, tagBase);
            releaseScm.setConnection(value);
        }
        if (scm.getDeveloperConnection() != null) {
            value = scmTranslator.translateTagUrl(scm.getDeveloperConnection(), tag, tagBase);
            releaseScm.setDeveloperConnection(value);
        }
        if (scm.getUrl() != null) {
            value = scmTranslator.translateTagUrl(scm.getUrl(), tag, tagBase);
            releaseScm.setUrl(value);
        }
        if (scm.getTag() != null) {
            value = scmTranslator.resolveTag(scm.getTag());
            releaseScm.setTag(value);
        }
        return releaseScm;
    }

    private List createReleaseDependencies(Map originalVersions, Map mappedVersions, MavenProject project) throws ReleaseFailureException {
        Set artifacts = project.getArtifacts();
        ArrayList<Dependency> releaseDependencies = null;
        if (artifacts != null) {
            ArrayList orderedArtifacts = new ArrayList();
            orderedArtifacts.addAll(artifacts);
            Collections.sort(orderedArtifacts);
            releaseDependencies = new ArrayList<Dependency>();
            Iterator iterator = orderedArtifacts.iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                Dependency releaseDependency = new Dependency();
                releaseDependency.setGroupId(artifact.getGroupId());
                releaseDependency.setArtifactId(artifact.getArtifactId());
                String version = this.getReleaseVersion(originalVersions, mappedVersions, artifact);
                releaseDependency.setVersion(version);
                releaseDependency.setType(artifact.getType());
                releaseDependency.setScope(artifact.getScope());
                releaseDependency.setClassifier(artifact.getClassifier());
                releaseDependencies.add(releaseDependency);
            }
        }
        return releaseDependencies;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getReleaseVersion(Map originalVersions, Map mappedVersions, Artifact artifact) throws ReleaseFailureException {
        String key = ArtifactUtils.versionlessKey((Artifact)artifact);
        String originalVersion = (String)originalVersions.get(key);
        String mappedVersion = (String)mappedVersions.get(key);
        String version = artifact.getVersion();
        if (version.equals(originalVersion)) {
            if (mappedVersion == null) throw new ReleaseFailureException("Version '" + version + "' for '" + key + "' was not mapped");
            return mappedVersion;
        }
        if (ArtifactUtils.isSnapshot((String)version)) return version;
        return artifact.getBaseVersion();
    }

    private List createReleasePlugins(Map originalVersions, Map mappedVersions, MavenProject project) throws ReleaseFailureException {
        List plugins;
        ArrayList<Plugin> releasePlugins = null;
        Build build = project.getOriginalModel().getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            Map artifactsById = project.getPluginArtifactMap();
            releasePlugins = new ArrayList<Plugin>();
            Iterator iterator = plugins.iterator();
            while (iterator.hasNext()) {
                Plugin plugin = (Plugin)iterator.next();
                String id = ArtifactUtils.versionlessKey((String)plugin.getGroupId(), (String)plugin.getArtifactId());
                Artifact artifact = (Artifact)artifactsById.get(id);
                String version = this.getReleaseVersion(originalVersions, mappedVersions, artifact);
                Plugin releasePlugin = new Plugin();
                releasePlugin.setGroupId(plugin.getGroupId());
                releasePlugin.setArtifactId(plugin.getArtifactId());
                releasePlugin.setVersion(version);
                releasePlugin.setExtensions(plugin.isExtensions());
                releasePlugin.setExecutions(plugin.getExecutions());
                releasePlugin.setDependencies(plugin.getDependencies());
                releasePlugin.setGoals(plugin.getGoals());
                releasePlugin.setInherited(plugin.getInherited());
                releasePlugin.setConfiguration(plugin.getConfiguration());
                releasePlugins.add(releasePlugin);
            }
        }
        return releasePlugins;
    }

    private List createReleaseReportPlugins(Map originalVersions, Map mappedVersions, MavenProject project) throws ReleaseFailureException {
        List reportPlugins;
        ArrayList<ReportPlugin> releaseReportPlugins = null;
        Reporting reporting = project.getModel().getReporting();
        if (reporting != null && (reportPlugins = reporting.getPlugins()) != null) {
            Map artifactsById = project.getReportArtifactMap();
            releaseReportPlugins = new ArrayList<ReportPlugin>();
            Iterator iterator = reportPlugins.iterator();
            while (iterator.hasNext()) {
                ReportPlugin reportPlugin = (ReportPlugin)iterator.next();
                String id = ArtifactUtils.versionlessKey((String)reportPlugin.getGroupId(), (String)reportPlugin.getArtifactId());
                Artifact artifact = (Artifact)artifactsById.get(id);
                String version = this.getReleaseVersion(originalVersions, mappedVersions, artifact);
                ReportPlugin releaseReportPlugin = new ReportPlugin();
                releaseReportPlugin.setGroupId(reportPlugin.getGroupId());
                releaseReportPlugin.setArtifactId(reportPlugin.getArtifactId());
                releaseReportPlugin.setVersion(version);
                releaseReportPlugin.setInherited(reportPlugin.getInherited());
                releaseReportPlugin.setConfiguration(reportPlugin.getConfiguration());
                releaseReportPlugin.setReportSets(reportPlugin.getReportSets());
                releaseReportPlugins.add(releaseReportPlugin);
            }
        }
        return releaseReportPlugins;
    }

    private List createReleaseExtensions(Map originalVersions, Map mappedVersions, MavenProject project) throws ReleaseFailureException {
        List extensions;
        ArrayList<Extension> releaseExtensions = null;
        Build build = project.getOriginalModel().getBuild();
        if (build != null && (extensions = build.getExtensions()) != null) {
            releaseExtensions = new ArrayList<Extension>();
            Iterator iterator = extensions.iterator();
            while (iterator.hasNext()) {
                Extension extension = (Extension)iterator.next();
                String id = ArtifactUtils.versionlessKey((String)extension.getGroupId(), (String)extension.getArtifactId());
                Artifact artifact = (Artifact)project.getExtensionArtifactMap().get(id);
                String version = this.getReleaseVersion(originalVersions, mappedVersions, artifact);
                Extension releaseExtension = new Extension();
                releaseExtension.setGroupId(extension.getGroupId());
                releaseExtension.setArtifactId(extension.getArtifactId());
                releaseExtension.setVersion(version);
                releaseExtensions.add(releaseExtension);
            }
        }
        return releaseExtensions;
    }

    public ReleaseResult clean(List reactorProjects) {
        ReleaseResult result = new ReleaseResult();
        Iterator iterator = reactorProjects.iterator();
        while (iterator.hasNext()) {
            MavenProject project = (MavenProject)iterator.next();
            File releasePom = ReleaseUtil.getReleasePom(project);
            if (!releasePom.exists()) continue;
            this.logInfo(result, "Deleting release POM for '" + project.getName() + "'...");
            if (releasePom.delete()) continue;
            this.logWarn(result, "Cannot delete release POM: " + releasePom);
        }
        result.setResultCode(0);
        return result;
    }
}

