/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.hash;

import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.JarData;
import org.apache.maven.shared.jar.identification.hash.JarHashAnalyzer;
import org.codehaus.plexus.digest.Digester;
import org.codehaus.plexus.digest.DigesterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class JarFileHashAnalyzer
extends AbstractLogEnabled
implements JarHashAnalyzer {
    private Digester digester;

    public String computeHash(JarAnalyzer jarAnalyzer) {
        JarData jarData = jarAnalyzer.getJarData();
        String result = jarData.getFileHash();
        if (result == null) {
            try {
                result = this.digester.calc(jarData.getFile());
                jarData.setFileHash(result);
            }
            catch (DigesterException e) {
                this.getLogger().warn("Unable to calculate the hashcode.", (Throwable)e);
            }
        }
        return result;
    }

    public void setDigester(Digester digester) {
        this.digester = digester;
    }
}

