/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.registry.api.PropertyExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPropertiesLoader.class);

    public Map<String, String> loadProperties(Configuration configuration) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        this.loadPropertiesFromConfigMap(configuration, propertiesMap);
        this.loadPropertiesFromExtendedClass(configuration, propertiesMap);
        return propertiesMap;
    }

    protected abstract Map<String, String> readProperties(Configuration var1);

    protected abstract String readPropertiesExtendedClass(Configuration var1);

    private void loadPropertiesFromConfigMap(Configuration configuration, Map<String, String> propertiesMap) {
        propertiesMap.putAll(this.readProperties(configuration));
    }

    private void loadPropertiesFromExtendedClass(Configuration configuration, Map<String, String> propertiesMap) {
        String extendedPropertyClass = this.readPropertiesExtendedClass(configuration);
        if (StringUtils.isEmpty((CharSequence)extendedPropertyClass)) {
            return;
        }
        try {
            Class<?> classExternalProperty = Class.forName(extendedPropertyClass);
            if (!PropertyExtended.class.isAssignableFrom(classExternalProperty)) {
                String errMsg = String.format("Define propertyExtendedClass %s in yaml, but not implement the interface PropertyExtended.", extendedPropertyClass);
                LOGGER.error(errMsg);
                throw new Error(errMsg);
            }
            PropertyExtended instance = (PropertyExtended)classExternalProperty.newInstance();
            Map<String, String> extendedPropertiesMap = instance.getExtendedProperties();
            if (extendedPropertiesMap != null && !extendedPropertiesMap.isEmpty()) {
                propertiesMap.putAll(extendedPropertiesMap);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String errMsg = "Fail to create instance of class: " + extendedPropertyClass;
            LOGGER.error(errMsg);
            throw new Error(errMsg, e);
        }
    }
}

