/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.version;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.registry.version.VersionRule;
import org.apache.servicecomb.registry.version.VersionRuleFixedParser;
import org.apache.servicecomb.registry.version.VersionRuleLatestParser;
import org.apache.servicecomb.registry.version.VersionRuleParser;
import org.apache.servicecomb.registry.version.VersionRuleRangeParser;
import org.apache.servicecomb.registry.version.VersionRuleStartFromParser;

public final class VersionRuleUtils {
    private static List<VersionRuleParser> parsers = new ArrayList<VersionRuleParser>();
    private static Map<String, VersionRule> versionRuleCache = new ConcurrentHashMapEx();

    public static VersionRule getOrCreate(String strVersionRule) {
        Objects.requireNonNull(strVersionRule);
        return versionRuleCache.computeIfAbsent(strVersionRule, VersionRuleUtils::create);
    }

    public static VersionRule create(String strVersionRule) {
        strVersionRule = strVersionRule.trim();
        for (VersionRuleParser parser : parsers) {
            VersionRule versionRule = parser.parse(strVersionRule);
            if (versionRule == null) continue;
            return versionRule;
        }
        throw new IllegalStateException("never run to here");
    }

    static {
        parsers.add(new VersionRuleLatestParser());
        parsers.add(new VersionRuleStartFromParser());
        parsers.add(new VersionRuleRangeParser());
        parsers.add(new VersionRuleFixedParser());
    }
}

