/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.governance.MatchersManager;
import org.apache.servicecomb.governance.event.GovernanceConfigurationChangedEvent;
import org.apache.servicecomb.governance.event.GovernanceEventManager;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGovernanceHandler<PROCESSOR, POLICY extends AbstractPolicy> {
    private Map<String, PROCESSOR> map = new ConcurrentHashMap<String, PROCESSOR>();
    private final Object lock = new Object();
    @Autowired
    protected MatchersManager matchersManager;

    protected AbstractGovernanceHandler() {
        GovernanceEventManager.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> PROCESSOR getActuator(GovernanceRequest governanceRequest) {
        POLICY policy = this.matchPolicy(governanceRequest);
        if (policy == null) {
            return null;
        }
        String key = this.createKey(policy);
        PROCESSOR processor = this.map.get(key);
        if (processor == null) {
            Object object = this.lock;
            synchronized (object) {
                processor = this.map.get(key);
                if (processor == null) {
                    processor = this.createProcessor(policy);
                    this.map.put(key, processor);
                }
            }
        }
        return processor;
    }

    protected abstract String createKey(POLICY var1);

    protected abstract POLICY matchPolicy(GovernanceRequest var1);

    protected abstract PROCESSOR createProcessor(POLICY var1);

    @Subscribe
    public void onDynamicConfigurationListener(GovernanceConfigurationChangedEvent event) {
        event.getChangedConfigurations().forEach(v -> this.map.remove(v));
    }
}

