/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.props;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.BackendExecutorType;
import org.apache.shardingsphere.infra.util.props.TypedPropertyKey;

public enum ConfigurationPropertyKey implements TypedPropertyKey
{
    SQL_SHOW("sql-show", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    SQL_SIMPLE("sql-simple", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    KERNEL_EXECUTOR_SIZE("kernel-executor-size", String.valueOf(0), Integer.TYPE, true),
    MAX_CONNECTIONS_SIZE_PER_QUERY("max-connections-size-per-query", String.valueOf(1), Integer.TYPE, false),
    CHECK_TABLE_METADATA_ENABLED("check-table-metadata-enabled", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    SQL_FEDERATION_TYPE("sql-federation-type", "NONE", String.class, false),
    PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE("proxy-frontend-database-protocol-type", "", String.class, false),
    PROXY_FRONTEND_FLUSH_THRESHOLD("proxy-frontend-flush-threshold", String.valueOf(128), Integer.TYPE, false),
    PROXY_HINT_ENABLED("proxy-hint-enabled", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    PROXY_BACKEND_QUERY_FETCH_SIZE("proxy-backend-query-fetch-size", String.valueOf(-1), Integer.TYPE, false),
    PROXY_FRONTEND_EXECUTOR_SIZE("proxy-frontend-executor-size", String.valueOf(0), Integer.TYPE, true),
    PROXY_BACKEND_EXECUTOR_SUITABLE("proxy-backend-executor-suitable", BackendExecutorType.OLAP.name(), BackendExecutorType.class, false),
    PROXY_FRONTEND_MAX_CONNECTIONS("proxy-frontend-max-connections", "0", Integer.TYPE, false),
    PROXY_BACKEND_DRIVER_TYPE("proxy-backend-driver-type", "JDBC", String.class, true),
    PROXY_MYSQL_DEFAULT_VERSION("proxy-mysql-default-version", "5.7.22", String.class, false),
    PROXY_DEFAULT_PORT("proxy-default-port", "3307", Integer.TYPE, true),
    PROXY_NETTY_BACKLOG("proxy-netty-backlog", "1024", Integer.TYPE, false),
    PROXY_INSTANCE_TYPE("proxy-instance-type", "Proxy", String.class, true);

    private final String key;
    private final String defaultValue;
    private final Class<?> type;
    private final boolean rebootRequired;

    public static Collection<String> getKeyNames() {
        return Arrays.stream(ConfigurationPropertyKey.values()).map(Enum::name).collect(Collectors.toList());
    }

    @Generated
    private ConfigurationPropertyKey(String key, String defaultValue, Class<?> type, boolean rebootRequired) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type;
        this.rebootRequired = rebootRequired;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @Generated
    public boolean isRebootRequired() {
        return this.rebootRequired;
    }
}

