/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.distsql.exception.rule;

import java.util.Collection;
import org.apache.shardingsphere.infra.distsql.exception.rule.RuleDefinitionViolationException;
import org.apache.shardingsphere.infra.util.exception.external.sql.sqlstate.SQLState;
import org.apache.shardingsphere.infra.util.exception.external.sql.sqlstate.XOpenSQLState;

public final class MissingRequiredRuleException
extends RuleDefinitionViolationException {
    private static final long serialVersionUID = -8464574460917965546L;

    public MissingRequiredRuleException(String ruleType) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 101, String.format("%s rule does not exist.", ruleType), new Object[0]);
    }

    public MissingRequiredRuleException(String ruleType, String databaseName) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 101, String.format("%s rule does not exist in database `%s`.", ruleType, databaseName), new Object[0]);
    }

    public MissingRequiredRuleException(String ruleType, Collection<String> ruleNames) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 101, String.format("%s rules `%s` do not exist.", ruleType, ruleNames), new Object[0]);
    }

    public MissingRequiredRuleException(String ruleType, String databaseName, String ruleName) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 101, String.format("%s rule `%s` do not exist in database `%s`.", ruleType, ruleName, databaseName), new Object[0]);
    }

    public MissingRequiredRuleException(String ruleType, String databaseName, Collection<String> ruleNames) {
        super((SQLState)XOpenSQLState.CHECK_OPTION_VIOLATION, 101, String.format("%s rules `%s` do not exist in database `%s`.", ruleType, ruleNames, databaseName), new Object[0]);
    }
}

