/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.user.yaml.config;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.metadata.user.yaml.config.YamlUserConfiguration;
import org.apache.shardingsphere.infra.metadata.user.yaml.swapper.YamlUserSwapper;

public final class YamlUsersConfigurationConverter {
    private static final YamlUserSwapper SWAPPER = new YamlUserSwapper();

    public static Collection<String> convertYamlUserConfigurations(Collection<ShardingSphereUser> users) {
        LinkedList<String> result = new LinkedList<String>();
        users.stream().map(SWAPPER::swapToYamlConfiguration).forEach(each -> result.add(each.toString()));
        return result;
    }

    public static Collection<ShardingSphereUser> convertShardingSphereUser(Collection<String> users) {
        Collection<YamlUserConfiguration> yamlUsers = YamlUsersConfigurationConverter.convertYamlUserConfiguration(users);
        return yamlUsers.stream().map(SWAPPER::swapToObject).collect(Collectors.toList());
    }

    public static Collection<YamlUserConfiguration> convertYamlUserConfiguration(Collection<String> users) {
        return users.stream().map(YamlUsersConfigurationConverter::convertYamlUserConfiguration).collect(Collectors.toList());
    }

    private static YamlUserConfiguration convertYamlUserConfiguration(String yamlUser) {
        Preconditions.checkArgument((0 < yamlUser.indexOf("@") && 0 < yamlUser.indexOf(":") && yamlUser.indexOf(":") <= yamlUser.length() - 1 ? 1 : 0) != 0, (String)"user configuration `%s` is invalid, the configuration format should be like `username@hostname:password`", (Object)yamlUser);
        Preconditions.checkArgument((yamlUser.indexOf("@") < yamlUser.indexOf(":") ? 1 : 0) != 0, (String)"user configuration `%s` is invalid, the configuration format should be like `username@hostname:password`", (Object)yamlUser);
        String username = yamlUser.substring(0, yamlUser.indexOf("@"));
        String hostname = yamlUser.substring(yamlUser.indexOf("@") + 1, yamlUser.indexOf(":"));
        String password = yamlUser.substring(yamlUser.indexOf(":") + 1);
        YamlUserConfiguration result = new YamlUserConfiguration();
        result.setUsername(username);
        result.setHostname(hostname);
        result.setPassword(password);
        return result;
    }

    @Generated
    private YamlUsersConfigurationConverter() {
    }
}

