/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.props;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.LoggerLevel;
import org.apache.shardingsphere.infra.util.props.TypedPropertyKey;

public enum ConfigurationPropertyKey implements TypedPropertyKey
{
    SYSTEM_LOG_LEVEL("system-log-level", LoggerLevel.INFO.name(), LoggerLevel.class, false),
    SQL_SHOW("sql-show", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    SQL_SIMPLE("sql-simple", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    KERNEL_EXECUTOR_SIZE("kernel-executor-size", String.valueOf(0), Integer.TYPE, true),
    MAX_CONNECTIONS_SIZE_PER_QUERY("max-connections-size-per-query", String.valueOf(1), Integer.TYPE, false),
    CHECK_TABLE_METADATA_ENABLED("check-table-metadata-enabled", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE("proxy-frontend-database-protocol-type", "", String.class, false),
    PROXY_FRONTEND_FLUSH_THRESHOLD("proxy-frontend-flush-threshold", String.valueOf(128), Integer.TYPE, false),
    PROXY_BACKEND_QUERY_FETCH_SIZE("proxy-backend-query-fetch-size", String.valueOf(-1), Integer.TYPE, false),
    PROXY_FRONTEND_EXECUTOR_SIZE("proxy-frontend-executor-size", String.valueOf(0), Integer.TYPE, true),
    PROXY_FRONTEND_MAX_CONNECTIONS("proxy-frontend-max-connections", "0", Integer.TYPE, false),
    PROXY_DEFAULT_PORT("proxy-default-port", "3307", Integer.TYPE, true),
    PROXY_NETTY_BACKLOG("proxy-netty-backlog", "1024", Integer.TYPE, false),
    CDC_SERVER_PORT("cdc-server-port", "33071", Integer.TYPE, true),
    PROXY_FRONTEND_SSL_ENABLED("proxy-frontend-ssl-enabled", String.valueOf(Boolean.FALSE), Boolean.TYPE, true),
    PROXY_FRONTEND_SSL_VERSION("proxy-frontend-ssl-version", "TLSv1.2,TLSv1.3", String.class, true),
    PROXY_FRONTEND_SSL_CIPHER("proxy-frontend-ssl-cipher", "", String.class, true),
    AGENT_PLUGINS_ENABLED("agent-plugins-enabled", String.valueOf(Boolean.TRUE), Boolean.TYPE, false);

    private final String key;
    private final String defaultValue;
    private final Class<?> type;
    private final boolean rebootRequired;

    public static Collection<String> getKeyNames() {
        return Arrays.stream(ConfigurationPropertyKey.values()).map(Enum::name).collect(Collectors.toList());
    }

    @Generated
    private ConfigurationPropertyKey(String key, String defaultValue, Class<?> type, boolean rebootRequired) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type;
        this.rebootRequired = rebootRequired;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @Generated
    public boolean isRebootRequired() {
        return this.rebootRequired;
    }
}

