/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.props;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourceReflection;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;

public final class DataSourcePropertiesCreator {
    public static Map<String, DataSourceProperties> create(Map<String, DataSourceConfiguration> dataSourceConfigs) {
        return dataSourceConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePropertiesCreator.create("com.zaxxer.hikari.HikariDataSource", (DataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public static DataSourceProperties create(String dataSourcePoolClassName, DataSourceConfiguration dataSourceConfig) {
        return new DataSourceProperties(dataSourcePoolClassName, DataSourcePropertiesCreator.createProperties(dataSourceConfig));
    }

    public static DataSourceProperties create(DataSource dataSource) {
        return new DataSourceProperties(dataSource.getClass().getName(), DataSourcePropertiesCreator.createProperties(dataSource));
    }

    private static Map<String, Object> createProperties(DataSourceConfiguration dataSourceConfig) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("url", dataSourceConfig.getConnection().getUrl());
        result.put("username", dataSourceConfig.getConnection().getUsername());
        result.put("password", dataSourceConfig.getConnection().getPassword());
        result.put("connectionTimeoutMilliseconds", dataSourceConfig.getPool().getConnectionTimeoutMilliseconds());
        result.put("idleTimeoutMilliseconds", dataSourceConfig.getPool().getIdleTimeoutMilliseconds());
        result.put("maxLifetimeMilliseconds", dataSourceConfig.getPool().getMaxLifetimeMilliseconds());
        result.put("maxPoolSize", dataSourceConfig.getPool().getMaxPoolSize());
        result.put("minPoolSize", dataSourceConfig.getPool().getMinPoolSize());
        result.put("readOnly", dataSourceConfig.getPool().getReadOnly());
        if (null != dataSourceConfig.getPool().getCustomProperties()) {
            result.putAll(dataSourceConfig.getPool().getCustomProperties());
        }
        return result;
    }

    private static Map<String, Object> createProperties(DataSource dataSource) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Optional poolMetaData = TypedSPILoader.findService(DataSourcePoolMetaData.class, (String)dataSource.getClass().getName());
        for (Map.Entry<String, Object> entry : new DataSourceReflection(dataSource).convertToProperties().entrySet()) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            if (poolMetaData.isPresent() && (!DataSourcePropertiesCreator.isValidProperty(propertyName, propertyValue, (DataSourcePoolMetaData)poolMetaData.get()) || ((DataSourcePoolMetaData)poolMetaData.get()).getTransientFieldNames().contains(propertyName))) continue;
            result.put(propertyName, propertyValue);
        }
        return result;
    }

    private static boolean isValidProperty(String key, Object value, DataSourcePoolMetaData poolMetaData) {
        return !poolMetaData.getInvalidProperties().containsKey(key) || null == value || !value.equals(poolMetaData.getInvalidProperties().get(key));
    }

    @Generated
    private DataSourcePropertiesCreator() {
    }
}

