/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic;

import com.google.common.base.Strings;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class OwnerToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private final int stopIndex;
    private final IdentifierValue ownerName;
    private final IdentifierValue tableName;

    public OwnerToken(int startIndex, int stopIndex, IdentifierValue ownerName, IdentifierValue tableName) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.ownerName = ownerName;
        this.tableName = tableName;
    }

    @Override
    public String toString(RouteUnit routeUnit) {
        if (null != this.ownerName && !Strings.isNullOrEmpty((String)this.ownerName.getValue()) && this.tableName.getValue().equals(this.ownerName.getValue())) {
            Set actualTableNames = routeUnit.getActualTableNames(this.tableName.getValue());
            String actualTableName = actualTableNames.isEmpty() ? this.tableName.getValue().toLowerCase() : (String)actualTableNames.iterator().next();
            return this.tableName.getQuoteCharacter().wrap(actualTableName) + ".";
        }
        return this.toString();
    }

    public String toString() {
        return null == this.ownerName || Strings.isNullOrEmpty((String)this.ownerName.getValue()) ? "" : this.ownerName.getValueWithQuoteCharacters() + ".";
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

