/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.path.item;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.mode.path.root.RuleRootNodePath;

public final class NamedRuleItemNodePath {
    private static final String NAME = "/(\\w+)/versions/\\d+$";
    private static final String ACTIVE_VERSION = "/(\\w+)/active_version$";
    private final String type;
    private final Pattern namePathPattern;
    private final Pattern activeVersionPathPattern;

    public NamedRuleItemNodePath(RuleRootNodePath rootNodePath, String type) {
        this.type = type;
        this.namePathPattern = Pattern.compile(rootNodePath.getNodePrefix() + type + NAME);
        this.activeVersionPathPattern = Pattern.compile(rootNodePath.getNodePrefix() + type + ACTIVE_VERSION);
    }

    public String getPath(String itemName) {
        return String.join((CharSequence)"/", this.type, itemName);
    }

    public Optional<String> getName(String path) {
        Matcher matcher = this.namePathPattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public Optional<String> getNameByActiveVersion(String path) {
        Matcher matcher = this.activeVersionPathPattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }
}

