/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.segment.ReadwriteSplittingRuleSegment;

public final class ReadwriteSplittingRuleStatementConverter {
    public static ReadwriteSplittingRuleConfiguration convert(Collection<ReadwriteSplittingRuleSegment> ruleSegments) {
        LinkedList<ReadwriteSplittingDataSourceRuleConfiguration> dataSources = new LinkedList<ReadwriteSplittingDataSourceRuleConfiguration>();
        HashMap<String, ShardingSphereAlgorithmConfiguration> loadBalancers = new HashMap<String, ShardingSphereAlgorithmConfiguration>(ruleSegments.size(), 1.0f);
        for (ReadwriteSplittingRuleSegment each : ruleSegments) {
            if (null != each.getLoadBalancer()) {
                String loadBalancerName = ReadwriteSplittingRuleStatementConverter.getLoadBalancerName(each.getName(), each.getLoadBalancer());
                loadBalancers.put(loadBalancerName, ReadwriteSplittingRuleStatementConverter.createLoadBalancer(each));
                dataSources.add(ReadwriteSplittingRuleStatementConverter.createDataSourceRuleConfiguration(each.getName(), ReadwriteSplittingRuleStatementConverter.createProperties(each), loadBalancerName, each.isAutoAware()));
                continue;
            }
            dataSources.add(ReadwriteSplittingRuleStatementConverter.createDataSourceRuleConfiguration(each.getName(), ReadwriteSplittingRuleStatementConverter.createProperties(each), null, each.isAutoAware()));
        }
        return new ReadwriteSplittingRuleConfiguration(dataSources, loadBalancers);
    }

    private static ReadwriteSplittingDataSourceRuleConfiguration createDataSourceRuleConfiguration(String name, Properties prop, String loadBalancerName, boolean isAutoAware) {
        return isAutoAware ? new ReadwriteSplittingDataSourceRuleConfiguration(name, "Dynamic", prop, loadBalancerName) : new ReadwriteSplittingDataSourceRuleConfiguration(name, "Static", prop, loadBalancerName);
    }

    private static ShardingSphereAlgorithmConfiguration createLoadBalancer(ReadwriteSplittingRuleSegment ruleSegment) {
        return new ShardingSphereAlgorithmConfiguration(ruleSegment.getLoadBalancer(), ruleSegment.getProps());
    }

    private static String getLoadBalancerName(String ruleName, String type) {
        return String.format("%s_%s", ruleName, type);
    }

    private static Properties createProperties(ReadwriteSplittingRuleSegment segment) {
        Properties properties = new Properties();
        if (segment.isAutoAware()) {
            properties.setProperty("auto-aware-data-source-name", segment.getAutoAwareResource());
        } else {
            properties.setProperty("write-data-source-name", segment.getWriteDataSource());
            properties.setProperty("read-data-source-names", String.join((CharSequence)",", segment.getReadDataSources()));
        }
        return properties;
    }

    @Generated
    private ReadwriteSplittingRuleStatementConverter() {
    }
}

