/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.parser.statement.ShowShadowAlgorithmsStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShadowAlgorithmQueryResultSet
implements DistSQLResultSet {
    private static final String SHADOW_ALGORITHM_NAME = "shadow_algorithm_name";
    private static final String TYPE = "type";
    private static final String PROPS = "props";
    private static final String DEFAULT = "is_default";
    private Iterator<Map.Entry<String, ShardingSphereAlgorithmConfiguration>> data = Collections.emptyIterator();
    private String defaultAlgorithm;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Optional<ShadowRuleConfiguration> rule = metaData.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShadowRuleConfiguration).map(each -> (ShadowRuleConfiguration)each).findAny();
        rule.ifPresent(configuration -> {
            this.data = configuration.getShadowAlgorithms().entrySet().iterator();
            this.defaultAlgorithm = configuration.getDefaultShadowAlgorithmName();
        });
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList(SHADOW_ALGORITHM_NAME, TYPE, PROPS, DEFAULT);
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.buildTableRowData(this.data.next());
    }

    private Collection<Object> buildTableRowData(Map.Entry<String, ShardingSphereAlgorithmConfiguration> data) {
        return Arrays.asList(data.getKey(), data.getValue().getType(), this.convertToString(data.getValue().getProps()), Boolean.valueOf(data.getKey().equals(this.defaultAlgorithm)).toString());
    }

    private String convertToString(Properties props) {
        return Objects.nonNull(props) ? PropertiesConverter.convert((Properties)props) : "";
    }

    public String getType() {
        return ShowShadowAlgorithmsStatement.class.getName();
    }
}

