/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.measure.v1;

import com.google.protobuf.GeneratedMessageV3;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import java.util.List;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;

public class BanyandbMeasureValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(BanyandbMeasure.DataPoint.class)) {
            return new DataPointValidator();
        }
        if (clazz.equals(BanyandbMeasure.QueryResponse.class)) {
            return new QueryResponseValidator();
        }
        if (clazz.equals(BanyandbMeasure.QueryRequest.class)) {
            return new QueryRequestValidator();
        }
        if (clazz.equals(BanyandbMeasure.TopNList.class)) {
            return new TopNListValidator();
        }
        if (clazz.equals(BanyandbMeasure.TopNResponse.class)) {
            return new TopNResponseValidator();
        }
        if (clazz.equals(BanyandbMeasure.TopNRequest.class)) {
            return new TopNRequestValidator();
        }
        if (clazz.equals(BanyandbMeasure.DataPointValue.class)) {
            return new DataPointValueValidator();
        }
        if (clazz.equals(BanyandbMeasure.WriteRequest.class)) {
            return new WriteRequestValidator();
        }
        if (clazz.equals(BanyandbMeasure.WriteResponse.class)) {
            return new WriteResponseValidator();
        }
        if (clazz.equals(BanyandbMeasure.DataPoint.Field.class)) {
            return new DataPoint_FieldValidator();
        }
        if (clazz.equals(BanyandbMeasure.QueryRequest.FieldProjection.class)) {
            return new QueryRequest_FieldProjectionValidator();
        }
        if (clazz.equals(BanyandbMeasure.QueryRequest.GroupBy.class)) {
            return new QueryRequest_GroupByValidator();
        }
        if (clazz.equals(BanyandbMeasure.QueryRequest.Aggregation.class)) {
            return new QueryRequest_AggregationValidator();
        }
        if (clazz.equals(BanyandbMeasure.QueryRequest.Top.class)) {
            return new QueryRequest_TopValidator();
        }
        if (clazz.equals(BanyandbMeasure.TopNList.Item.class)) {
            return new TopNList_ItemValidator();
        }
        return null;
    }

    public static class DataPointValidator
    implements ValidatorImpl<BanyandbMeasure.DataPoint> {
        public void assertValid(BanyandbMeasure.DataPoint proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasTimestamp()) {
                index.validatorFor((Object)proto.getTimestamp()).assertValid((Object)proto.getTimestamp());
            }
            RepeatedValidation.forEach(proto.getTagFamiliesList(), item -> index.validatorFor(item).assertValid(item));
            RepeatedValidation.forEach(proto.getFieldsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class QueryResponseValidator
    implements ValidatorImpl<BanyandbMeasure.QueryResponse> {
        public void assertValid(BanyandbMeasure.QueryResponse proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getDataPointsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class QueryRequestValidator
    implements ValidatorImpl<BanyandbMeasure.QueryRequest> {
        public void assertValid(BanyandbMeasure.QueryRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.measure.v1.QueryRequest.metadata", (GeneratedMessageV3)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.measure.v1.QueryRequest.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            if (proto.hasTimeRange()) {
                RequiredValidation.required((String)".banyandb.measure.v1.QueryRequest.time_range", (GeneratedMessageV3)proto.getTimeRange());
            } else {
                RequiredValidation.required((String)".banyandb.measure.v1.QueryRequest.time_range", null);
            }
            if (proto.hasTimeRange()) {
                index.validatorFor((Object)proto.getTimeRange()).assertValid((Object)proto.getTimeRange());
            }
            if (proto.hasCriteria()) {
                index.validatorFor((Object)proto.getCriteria()).assertValid((Object)proto.getCriteria());
            }
            if (proto.hasTagProjection()) {
                RequiredValidation.required((String)".banyandb.measure.v1.QueryRequest.tag_projection", (GeneratedMessageV3)proto.getTagProjection());
            } else {
                RequiredValidation.required((String)".banyandb.measure.v1.QueryRequest.tag_projection", null);
            }
            if (proto.hasTagProjection()) {
                index.validatorFor((Object)proto.getTagProjection()).assertValid((Object)proto.getTagProjection());
            }
            if (proto.hasFieldProjection()) {
                index.validatorFor((Object)proto.getFieldProjection()).assertValid((Object)proto.getFieldProjection());
            }
            if (proto.hasGroupBy()) {
                index.validatorFor((Object)proto.getGroupBy()).assertValid((Object)proto.getGroupBy());
            }
            if (proto.hasAgg()) {
                index.validatorFor((Object)proto.getAgg()).assertValid((Object)proto.getAgg());
            }
            if (proto.hasTop()) {
                index.validatorFor((Object)proto.getTop()).assertValid((Object)proto.getTop());
            }
            if (proto.hasOrderBy()) {
                index.validatorFor((Object)proto.getOrderBy()).assertValid((Object)proto.getOrderBy());
            }
        }
    }

    public static class TopNListValidator
    implements ValidatorImpl<BanyandbMeasure.TopNList> {
        public void assertValid(BanyandbMeasure.TopNList proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasTimestamp()) {
                index.validatorFor((Object)proto.getTimestamp()).assertValid((Object)proto.getTimestamp());
            }
            RepeatedValidation.forEach(proto.getItemsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TopNResponseValidator
    implements ValidatorImpl<BanyandbMeasure.TopNResponse> {
        public void assertValid(BanyandbMeasure.TopNResponse proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getListsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class TopNRequestValidator
    implements ValidatorImpl<BanyandbMeasure.TopNRequest> {
        private final Integer TOP_N__GT = 0;

        public void assertValid(BanyandbMeasure.TopNRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.measure.v1.TopNRequest.metadata", (GeneratedMessageV3)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.measure.v1.TopNRequest.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            if (proto.hasTimeRange()) {
                RequiredValidation.required((String)".banyandb.measure.v1.TopNRequest.time_range", (GeneratedMessageV3)proto.getTimeRange());
            } else {
                RequiredValidation.required((String)".banyandb.measure.v1.TopNRequest.time_range", null);
            }
            if (proto.hasTimeRange()) {
                index.validatorFor((Object)proto.getTimeRange()).assertValid((Object)proto.getTimeRange());
            }
            ComparativeValidation.greaterThan((String)".banyandb.measure.v1.TopNRequest.top_n", (Object)proto.getTopN(), (Object)this.TOP_N__GT, Comparator.naturalOrder());
            RepeatedValidation.forEach(proto.getConditionsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class DataPointValueValidator
    implements ValidatorImpl<BanyandbMeasure.DataPointValue> {
        public void assertValid(BanyandbMeasure.DataPointValue proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasTimestamp()) {
                RequiredValidation.required((String)".banyandb.measure.v1.DataPointValue.timestamp", (GeneratedMessageV3)proto.getTimestamp());
            } else {
                RequiredValidation.required((String)".banyandb.measure.v1.DataPointValue.timestamp", null);
            }
            RepeatedValidation.minItems((String)".banyandb.measure.v1.DataPointValue.tag_families", proto.getTagFamiliesList(), (int)1);
            RepeatedValidation.forEach(proto.getTagFamiliesList(), item -> index.validatorFor(item).assertValid(item));
            RepeatedValidation.forEach(proto.getFieldsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class WriteRequestValidator
    implements ValidatorImpl<BanyandbMeasure.WriteRequest> {
        public void assertValid(BanyandbMeasure.WriteRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.measure.v1.WriteRequest.metadata", (GeneratedMessageV3)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.measure.v1.WriteRequest.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            if (proto.hasDataPoint()) {
                RequiredValidation.required((String)".banyandb.measure.v1.WriteRequest.data_point", (GeneratedMessageV3)proto.getDataPoint());
            } else {
                RequiredValidation.required((String)".banyandb.measure.v1.WriteRequest.data_point", null);
            }
            if (proto.hasDataPoint()) {
                index.validatorFor((Object)proto.getDataPoint()).assertValid((Object)proto.getDataPoint());
            }
        }
    }

    public static class WriteResponseValidator
    implements ValidatorImpl<BanyandbMeasure.WriteResponse> {
        public void assertValid(BanyandbMeasure.WriteResponse proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class DataPoint_FieldValidator
    implements ValidatorImpl<BanyandbMeasure.DataPoint.Field> {
        public void assertValid(BanyandbMeasure.DataPoint.Field proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasValue()) {
                index.validatorFor((Object)proto.getValue()).assertValid((Object)proto.getValue());
            }
        }
    }

    public static class QueryRequest_FieldProjectionValidator
    implements ValidatorImpl<BanyandbMeasure.QueryRequest.FieldProjection> {
        public void assertValid(BanyandbMeasure.QueryRequest.FieldProjection proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach((List)proto.getNamesList(), item -> {});
        }
    }

    public static class QueryRequest_GroupByValidator
    implements ValidatorImpl<BanyandbMeasure.QueryRequest.GroupBy> {
        public void assertValid(BanyandbMeasure.QueryRequest.GroupBy proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasTagProjection()) {
                index.validatorFor((Object)proto.getTagProjection()).assertValid((Object)proto.getTagProjection());
            }
        }
    }

    public static class QueryRequest_AggregationValidator
    implements ValidatorImpl<BanyandbMeasure.QueryRequest.Aggregation> {
        public void assertValid(BanyandbMeasure.QueryRequest.Aggregation proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class QueryRequest_TopValidator
    implements ValidatorImpl<BanyandbMeasure.QueryRequest.Top> {
        public void assertValid(BanyandbMeasure.QueryRequest.Top proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class TopNList_ItemValidator
    implements ValidatorImpl<BanyandbMeasure.TopNList.Item> {
        public void assertValid(BanyandbMeasure.TopNList.Item proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasValue()) {
                index.validatorFor((Object)proto.getValue()).assertValid((Object)proto.getValue());
            }
        }
    }
}

