/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.auto.value.AutoValue;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.banyandb.v1.client.AbstractWrite;
import org.apache.skywalking.banyandb.v1.client.AutoValue_AbstractBulkWriteProcessor_Holder;
import org.apache.skywalking.banyandb.v1.client.BulkWriteProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBulkWriteProcessor<REQ extends GeneratedMessageV3, STUB extends AbstractAsyncStub<STUB>>
extends BulkWriteProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractBulkWriteProcessor.class);
    private final STUB stub;

    protected AbstractBulkWriteProcessor(STUB stub, String processorName, int maxBulkSize, int flushInterval, int concurrency) {
        super(processorName, maxBulkSize, flushInterval, concurrency);
        this.stub = stub;
    }

    public CompletableFuture<Void> add(AbstractWrite<REQ> writeEntity) {
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        this.buffer.produce(Holder.create(writeEntity, f));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush(List data) {
        CompletableFuture<Void> batch = new CompletableFuture<Void>();
        StreamObserver writeRequestStreamObserver = this.buildStreamObserver((AbstractAsyncStub)this.stub.withDeadlineAfter((long)this.flushInterval, TimeUnit.SECONDS), batch);
        ArrayList sentData = new ArrayList(data.size());
        try {
            data.forEach(holder -> {
                Object request;
                Holder h = (Holder)holder;
                AbstractWrite entity = h.writeEntity();
                try {
                    request = entity.build();
                }
                catch (Throwable bt) {
                    log.error("building the entity fails: {}", (Object)entity.toString(), (Object)bt);
                    h.future().completeExceptionally(bt);
                    return;
                }
                writeRequestStreamObserver.onNext(request);
                sentData.add(h);
            });
        }
        catch (Throwable t) {
            log.error("Transform and send request to BanyanDB fail.", t);
            batch.completeExceptionally(t);
        }
        finally {
            writeRequestStreamObserver.onCompleted();
        }
        batch.whenComplete((ignored, exp) -> {
            if (exp != null) {
                sentData.stream().map(o -> ((Holder)o).future()).forEach(it -> it.completeExceptionally((Throwable)exp));
                log.error("Failed to execute requests in bulk", exp);
            } else {
                log.debug("Succeeded to execute {} requests in bulk", (Object)data.size());
                sentData.stream().map(o -> ((Holder)o).future()).forEach(it -> it.complete(null));
            }
        });
        try {
            batch.get(30L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            log.error("Waiting responses from BanyanDB fail.", t);
        }
    }

    protected abstract StreamObserver<REQ> buildStreamObserver(STUB var1, CompletableFuture<Void> var2);

    @AutoValue
    static abstract class Holder {
        Holder() {
        }

        abstract AbstractWrite writeEntity();

        abstract CompletableFuture<Void> future();

        public static <REQ extends GeneratedMessageV3> Holder create(AbstractWrite<REQ> writeEntity, CompletableFuture<Void> future) {
            return new AutoValue_AbstractBulkWriteProcessor_Holder(writeEntity, future);
        }
    }
}

